/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.th0rgal.oraxen.utils.OS;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class VirtualFile
implements Comparable<VirtualFile> {
    private String parentFolder;
    private String name;
    private InputStream inputStream;

    public VirtualFile(String parentFolder, String name, InputStream inputStream) {
        this.parentFolder = OS.getOs().getName().startsWith("Windows") ? parentFolder.replace("\\", "/") : parentFolder;
        this.name = name;
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getPath() {
        return this.parentFolder.isEmpty() ? this.name : this.parentFolder + "/" + this.name;
    }

    public void setPath(String newPath) {
        String newParent = newPath.substring(0, newPath.lastIndexOf("/"));
        this.parentFolder = OS.getOs().getName().startsWith("Windows") ? newParent.replace("\\", "/") : newParent;
        this.name = newPath.substring(newPath.lastIndexOf("/") + 1);
    }

    @Override
    public int compareTo(@NotNull VirtualFile other) {
        return other.getPath().compareTo(this.getPath());
    }

    public JsonElement toJsonElement() {
        String fontContent;
        InputStream fontInput = this.inputStream;
        try {
            fontContent = IOUtils.toString((InputStream)fontInput, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Logs.logError(Utils.removeParentDirs(this.getPath()) + " was empty");
            return null;
        }
        return JsonParser.parseString((String)fontContent);
    }
}

