/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ModelEngineUtils {
    private static final ModelEngineVersion version = ModelEngineUtils.getVersion();
    private static Method setRotationLockMethod;
    private static Method addModel;

    static ModelEngineVersion getVersion() {
        try {
            Class.forName("com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint");
            return ModelEngineVersion.MEG_4;
        }
        catch (Exception e) {
            return ModelEngineVersion.MEG_3;
        }
    }

    public static void addModel(ModeledEntity entity, ActiveModel model, boolean overrideHitboxes) {
        block2: {
            try {
                addModel.invoke((Object)entity, model, overrideHitboxes);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (!Settings.DEBUG.toBool().booleanValue()) break block2;
                Logs.logError(e.getMessage());
            }
        }
    }

    public static void setRotationLock(ModeledEntity model, boolean lock) {
        block2: {
            try {
                setRotationLockMethod.invoke((Object)model, lock);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (!Settings.DEBUG.toBool().booleanValue()) break block2;
                Logs.logError(e.getMessage());
            }
        }
    }

    static {
        try {
            Class<?> modeledEntityClass = Class.forName(ModeledEntity.class.getName());
            setRotationLockMethod = version == ModelEngineVersion.MEG_4 ? modeledEntityClass.getDeclaredMethod("setModelRotationLocked", Boolean.TYPE) : modeledEntityClass.getDeclaredMethod("setModelRotationLock", Boolean.TYPE);
            addModel = modeledEntityClass.getDeclaredMethod("addModel", ActiveModel.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    static enum ModelEngineVersion {
        MEG_4,
        MEG_3;

    }
}

