/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.sound;

import io.th0rgal.oraxen.sound.CustomSound;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class SoundManager {
    private final boolean autoGenerate;
    private final Collection<CustomSound> customSounds;

    public SoundManager(YamlConfiguration soundConfig) {
        this.autoGenerate = soundConfig.getBoolean("settings.automatically_generate");
        this.customSounds = this.autoGenerate ? this.parseCustomSounds(Objects.requireNonNull(soundConfig.getConfigurationSection("sounds"))) : new ArrayList<CustomSound>();
    }

    public Collection<CustomSound> parseCustomSounds(ConfigurationSection section) {
        ArrayList<CustomSound> output = new ArrayList<CustomSound>();
        for (String soundName : section.getKeys(true)) {
            ConfigurationSection sound = section.getConfigurationSection(soundName);
            if (sound == null) continue;
            SoundCategory category = null;
            if (sound.isString("category")) {
                try {
                    category = Objects.requireNonNullElse(SoundCategory.valueOf((String)sound.getString("category").toUpperCase(Locale.ROOT)), SoundCategory.MASTER);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            List<String> sounds = sound.getStringList("sounds").isEmpty() ? Collections.singletonList(sound.getString("sound")) : sound.getStringList("sounds");
            output.add(new CustomSound(soundName, sounds, category, sound.getBoolean("replace"), sound.getString("subtitle")));
        }
        return output;
    }

    public Collection<CustomSound> getCustomSounds() {
        return new ArrayList<CustomSound>(this.customSounds);
    }

    public boolean isAutoGenerate() {
        return this.autoGenerate;
    }
}

