/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes.builders;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.utils.OraxenYaml;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class RecipeBuilder {
    private static final Map<UUID, RecipeBuilder> MAP = new HashMap<UUID, RecipeBuilder>();
    private Inventory inventory;
    private File configFile;
    private YamlConfiguration config;
    private final String inventoryTitle;
    private final Player player;
    private final String builderName;

    protected RecipeBuilder(Player player, String builderName) {
        this.player = player;
        this.builderName = builderName;
        this.inventoryTitle = player.getName() + " " + builderName + " builder";
        UUID playerId = player.getUniqueId();
        this.inventory = MAP.containsKey(playerId) && RecipeBuilder.MAP.get((Object)playerId).builderName.equals(builderName) ? RecipeBuilder.MAP.get((Object)playerId).inventory : this.createInventory(player, this.inventoryTitle);
        player.openInventory(this.inventory);
        MAP.put(playerId, this);
    }

    abstract Inventory createInventory(Player var1, String var2);

    void close() {
        MAP.remove(this.player.getUniqueId());
    }

    public abstract void saveRecipe(String var1);

    public abstract void saveRecipe(String var1, String var2);

    protected Inventory getInventory() {
        return this.inventory;
    }

    protected void setSerializedItem(ConfigurationSection section, ItemStack itemStack) {
        if (OraxenItems.exists(itemStack)) {
            String itemID = OraxenItems.getIdByItem(itemStack);
            section.set("oraxen_item", (Object)itemID);
        } else if (itemStack != null && itemStack.equals((Object)new ItemStack(itemStack.getType()))) {
            section.set("minecraft_type", (Object)itemStack.getType().toString());
        } else {
            section.set("minecraft_item", (Object)itemStack);
        }
    }

    public YamlConfiguration getConfig() {
        if (this.configFile == null) {
            this.configFile = OraxenPlugin.get().getResourceManager().extractConfiguration("recipes/" + this.builderName + ".yml");
            this.config = OraxenYaml.loadConfiguration(this.configFile);
        }
        return this.config;
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
        MAP.put(this.player.getUniqueId(), this);
    }

    public String getInventoryTitle() {
        return this.inventoryTitle;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public static RecipeBuilder get(UUID playerUUID) {
        return MAP.get(playerUUID);
    }
}

