/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation.slicer;

import io.th0rgal.oraxen.pack.generation.slicer.Box;
import io.th0rgal.oraxen.pack.generation.slicer.Slicer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OutputFile {
    private static final Color REMOVED_MARKER = new Color(128, 0, 0, 128);
    public final String path;
    private final Box box;
    private final List<UnaryOperator<BufferedImage>> transformers = new ArrayList<UnaryOperator<BufferedImage>>();
    @Nullable
    private String metadata;

    public OutputFile(String path, Box box) {
        this.path = path;
        this.box = box;
    }

    public void process(Path root, Path imagePath, BufferedImage image, Graphics leftover) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        Path outputPath = root.resolve(this.path);
        int x = this.box.scaleX(width);
        int y = this.box.scaleY(height);
        int w = this.box.scaleW(width);
        int h = this.box.scaleH(height);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        if (x == 0 && y == 0 && w == width && h == height && this.transformers.isEmpty()) {
            Files.copy(imagePath, outputPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            BufferedImage subImage = image.getSubimage(x, y, w, h);
            for (UnaryOperator<BufferedImage> op : this.transformers) {
                subImage = (BufferedImage)op.apply(subImage);
            }
            Slicer.writeImage(outputPath, subImage);
        }
        Path inputMetaPath = OutputFile.getMetaPath(imagePath);
        if (Files.exists(inputMetaPath, new LinkOption[0])) {
            Files.copy(inputMetaPath, OutputFile.getMetaPath(outputPath), StandardCopyOption.REPLACE_EXISTING);
        } else if (this.metadata != null) {
            Files.writeString(OutputFile.getMetaPath(outputPath), (CharSequence)this.metadata, new OpenOption[0]);
        }
        leftover.setColor(REMOVED_MARKER);
        leftover.fillRect(x, y, w, h);
    }

    private static Path getMetaPath(Path path) {
        return path.resolveSibling(path.getFileName().toString() + ".mcmeta");
    }

    public OutputFile apply(UnaryOperator<BufferedImage> transform) {
        this.transformers.add(transform);
        return this;
    }

    public OutputFile metadata(String metadata) {
        this.metadata = metadata;
        return this;
    }
}

