/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.custom.listeners;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.misc.custom.fields.CustomEvent;
import io.th0rgal.oraxen.mechanics.provided.misc.custom.listeners.CustomListener;
import io.th0rgal.oraxen.utils.actions.ClickAction;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ClickListener
extends CustomListener {
    private final Set<Action> interactActions = new HashSet<Action>();

    public ClickListener(String itemID, long cooldown, CustomEvent event, ClickAction clickAction) {
        super(itemID, cooldown, event, clickAction);
        switch (event.getParams().get(0)) {
            case "right": {
                if (event.getParams().get(1).equals("all")) {
                    this.interactActions.add(Action.RIGHT_CLICK_AIR);
                    this.interactActions.add(Action.RIGHT_CLICK_BLOCK);
                    break;
                }
                if (event.getParams().get(1).equals("block")) {
                    this.interactActions.add(Action.RIGHT_CLICK_BLOCK);
                    break;
                }
                this.interactActions.add(Action.RIGHT_CLICK_AIR);
                break;
            }
            case "left": {
                if (event.getParams().get(1).equals("all")) {
                    this.interactActions.add(Action.LEFT_CLICK_AIR);
                    this.interactActions.add(Action.LEFT_CLICK_BLOCK);
                    break;
                }
                if (event.getParams().get(1).equals("block")) {
                    this.interactActions.add(Action.LEFT_CLICK_BLOCK);
                    break;
                }
                this.interactActions.add(Action.LEFT_CLICK_AIR);
                break;
            }
            case "all": {
                if (event.getParams().get(1).equals("all")) {
                    this.interactActions.add(Action.RIGHT_CLICK_AIR);
                    this.interactActions.add(Action.RIGHT_CLICK_BLOCK);
                    this.interactActions.add(Action.LEFT_CLICK_AIR);
                    this.interactActions.add(Action.LEFT_CLICK_BLOCK);
                    break;
                }
                if (event.getParams().get(1).equals("block")) {
                    this.interactActions.add(Action.RIGHT_CLICK_BLOCK);
                    this.interactActions.add(Action.LEFT_CLICK_BLOCK);
                    break;
                }
                this.interactActions.add(Action.RIGHT_CLICK_AIR);
                this.interactActions.add(Action.LEFT_CLICK_AIR);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getParams().get(0));
            }
        }
    }

    @EventHandler
    public void onClicked(PlayerInteractEvent event) {
        if (this.interactActions.contains(event.getAction())) {
            ItemStack item = event.getItem();
            if (!this.itemID.equals(OraxenItems.getIdByItem(item))) {
                return;
            }
            this.perform(event.getPlayer(), item);
        }
    }
}

