/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.custom;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.custom.fields.CustomEvent;
import io.th0rgal.oraxen.mechanics.provided.misc.custom.listeners.CustomListener;
import io.th0rgal.oraxen.utils.actions.ClickAction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;

public class CustomMechanic
extends Mechanic {
    private static final Map<String, CustomListener> LOADED_VARIANTS = new HashMap<String, CustomListener>();

    public CustomMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        for (String subMechanicName : section.getKeys(false)) {
            ClickAction clickAction;
            ConfigurationSection subsection = section.getConfigurationSection(subMechanicName);
            if (subsection == null) continue;
            String key = subsection.getCurrentPath();
            CustomListener loadedListener = LOADED_VARIANTS.get(key);
            if (loadedListener != null) {
                loadedListener.unregister();
            }
            if ((clickAction = ClickAction.from(subsection)) == null) continue;
            CustomListener listener = new CustomEvent(subsection.getString("event", ""), subsection.getBoolean("one_usage", false)).getListener(this.getItemID(), subsection.getLong("cooldown"), clickAction);
            listener.register();
            LOADED_VARIANTS.put(key, listener);
        }
    }
}

