/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockSoundListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingTask;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Range;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class StringBlockMechanicFactory
extends MechanicFactory {
    public static final Map<Integer, StringBlockMechanic> BLOCK_PER_VARIATION = new HashMap<Integer, StringBlockMechanic>();
    private static JsonObject variants;
    private static StringBlockMechanicFactory instance;
    public final List<String> toolTypes;
    private boolean sapling;
    private static SaplingTask saplingTask;
    private final int saplingGrowthCheckDelay;
    public final boolean customSounds;
    public final boolean disableVanillaString;

    public StringBlockMechanicFactory(ConfigurationSection section) {
        super(section);
        instance = this;
        variants = new JsonObject();
        variants.add("east=false,west=false,south=false,north=false,attached=false,disarmed=false,powered=false", (JsonElement)StringBlockMechanicFactory.getModelJson("block/barrier"));
        this.toolTypes = section.getStringList("tool_types");
        this.saplingGrowthCheckDelay = section.getInt("sapling_growth_check_delay");
        this.sapling = false;
        this.customSounds = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds").getBoolean("stringblock_and_furniture", true);
        this.disableVanillaString = section.getBoolean("disable_vanilla_strings", true);
        OraxenPlugin.get().getResourcePack().addModifiers(this.getMechanicID(), packFolder -> {
            OraxenPlugin.get().getResourcePack();
            ResourcePack.writeStringToVirtual("assets/minecraft/blockstates", "tripwire.json", this.getBlockstateContent());
        });
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new StringBlockMechanicListener(this), new SaplingListener());
        if (this.customSounds) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new StringBlockSoundListener());
        }
        if (VersionUtil.isPaperServer()) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new StringBlockMechanicListener.StringBlockMechanicPaperListener());
        }
        if (!VersionUtil.isPaperServer() || !NMSHandlers.isTripwireUpdatesDisabled()) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new StringBlockMechanicListener.StringBlockMechanicPhysicsListener());
        }
        if (VersionUtil.isPaperServer() && VersionUtil.atOrAbove("1.20.1") && !NMSHandlers.isTripwireUpdatesDisabled()) {
            Logs.logError("Papers block-updates.disable-tripwire-updates is not enabled.");
            Logs.logWarning("It is recommended to enable this setting for improved performance and prevent bugs with tripwires");
            Logs.logWarning("Otherwise Oraxen needs to listen to very taxing events, which also introduces some bugs");
            Logs.logWarning("You can enable this setting in ServerFolder/config/paper-global.yml", true);
        }
    }

    public static JsonObject getModelJson(String modelName) {
        JsonObject content = new JsonObject();
        content.addProperty("model", modelName);
        return content;
    }

    public static String getBlockstateVariantName(int id) {
        return "east=" + ((id & 1) == 1 ? "true" : "false") + ",west=" + ((id >> 1 & 1) == 1 ? "true" : "false") + ",south=" + ((id >> 2 & 1) == 1 ? "true" : "false") + ",north=" + ((id >> 3 & 1) == 1 ? "true" : "false") + ",attached=" + ((id >> 4 & 1) == 1 ? "true" : "false") + ",disarmed=" + ((id >> 5 & 1) == 1 ? "true" : "false") + ",powered=" + ((id >> 6 & 1) == 1 ? "true" : "false");
    }

    @Nullable
    public static StringBlockMechanic getBlockMechanic(int customVariation) {
        return BLOCK_PER_VARIATION.get(customVariation);
    }

    public static boolean isEnabled() {
        return instance != null;
    }

    public static StringBlockMechanicFactory getInstance() {
        return instance;
    }

    public static void setBlockModel(Block block, String itemId) {
        MechanicFactory mechanicFactory = MechanicsManager.getMechanicFactory("stringblock");
        StringBlockMechanic stringBlockMechanic = (StringBlockMechanic)mechanicFactory.getMechanic(itemId);
        block.setBlockData(StringBlockMechanicFactory.createTripwireData(stringBlockMechanic.getCustomVariation()));
    }

    private String getBlockstateContent() {
        JsonObject tripwire = new JsonObject();
        tripwire.add("variants", (JsonElement)variants);
        return tripwire.toString();
    }

    @Override
    public Mechanic parse(ConfigurationSection itemMechanicConfiguration) {
        StringBlockMechanic mechanic = new StringBlockMechanic(this, itemMechanicConfiguration);
        if (!Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(127)).contains((Object)mechanic.getCustomVariation())) {
            Logs.logError("The custom variation of the block " + mechanic.getItemID() + " is not between 1 and 127!");
            Logs.logWarning("The item has failed to build for now to prevent bugs and issues.");
        }
        variants.add(StringBlockMechanicFactory.getBlockstateVariantName(mechanic.getCustomVariation()), (JsonElement)StringBlockMechanicFactory.getModelJson(mechanic.getModel(itemMechanicConfiguration.getParent().getParent())));
        BLOCK_PER_VARIATION.put(mechanic.getCustomVariation(), mechanic);
        this.addToImplemented(mechanic);
        return mechanic;
    }

    @Override
    public StringBlockMechanic getMechanic(String itemID) {
        return (StringBlockMechanic)super.getMechanic(itemID);
    }

    @Override
    public StringBlockMechanic getMechanic(ItemStack itemStack) {
        return (StringBlockMechanic)super.getMechanic(itemStack);
    }

    public static int getCode(Tripwire blockData) {
        List<BlockFace> properties = Arrays.asList(BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH);
        int sum = 0;
        for (BlockFace blockFace : blockData.getFaces()) {
            sum += (int)Math.pow(2.0, properties.indexOf(blockFace));
        }
        if (blockData.isAttached()) {
            sum += (int)Math.pow(2.0, 4.0);
        }
        if (blockData.isDisarmed()) {
            sum += (int)Math.pow(2.0, 5.0);
        }
        if (blockData.isPowered()) {
            sum += (int)Math.pow(2.0, 6.0);
        }
        return sum;
    }

    public static BlockData createTripwireData(int code) {
        Tripwire data = (Tripwire)Bukkit.createBlockData((Material)Material.TRIPWIRE);
        int i = 0;
        for (BlockFace face : new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH}) {
            data.setFace(face, (code & 1 << i++) != 0);
        }
        data.setAttached((code & 1 << i++) != 0);
        data.setDisarmed((code & 1 << i++) != 0);
        data.setPowered((code & 1 << i) != 0);
        return data;
    }

    public BlockData createTripwireData(String itemID) {
        return StringBlockMechanicFactory.createTripwireData(StringBlockMechanicFactory.getInstance().getMechanic(itemID).getCustomVariation());
    }

    public void registerSaplingMechanic() {
        if (this.sapling) {
            return;
        }
        if (saplingTask != null) {
            saplingTask.cancel();
        }
        saplingTask = new SaplingTask(this.saplingGrowthCheckDelay);
        saplingTask.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, this.saplingGrowthCheckDelay);
        this.sapling = true;
    }
}

