/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock;

import io.th0rgal.oraxen.compatibilities.provided.blocklocker.BlockLockerMechanic;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingMechanic;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.oraxen.utils.drops.Drop;
import io.th0rgal.oraxen.utils.drops.Loot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;

public class StringBlockMechanic
extends Mechanic {
    private final int customVariation;
    private final Drop drop;
    private final BlockSounds blockSounds;
    private final LimitedPlacing limitedPlacing;
    private String model;
    private final int hardness;
    private final int light;
    private final List<String> randomPlaceBlock;
    private final SaplingMechanic saplingMechanic;
    private final boolean isTall;
    private final BlockLockerMechanic blockLocker;

    public StringBlockMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.model = section.getString("model");
        this.customVariation = section.getInt("custom_variation");
        this.isTall = section.getBoolean("is_tall", false);
        this.light = Math.min(section.getInt("light", -1), 15);
        this.hardness = section.getInt("hardness", 1);
        ConfigurationSection dropSection = section.getConfigurationSection("drop");
        this.drop = dropSection != null ? Drop.createDrop(StringBlockMechanicFactory.getInstance().toolTypes, dropSection, this.getItemID()) : new Drop(new ArrayList<Loot>(), false, false, this.getItemID());
        ConfigurationSection randomPlaceSection = section.getConfigurationSection("random_place");
        this.randomPlaceBlock = randomPlaceSection != null ? randomPlaceSection.getStringList("blocks") : new ArrayList();
        ConfigurationSection saplingSection = section.getConfigurationSection("sapling");
        this.saplingMechanic = saplingSection != null ? new SaplingMechanic(this.getItemID(), saplingSection) : null;
        ConfigurationSection limitedSection = section.getConfigurationSection("limited_placing");
        this.limitedPlacing = limitedSection != null ? new LimitedPlacing(limitedSection) : null;
        ConfigurationSection blockSoundsSection = section.getConfigurationSection("block_sounds");
        this.blockSounds = blockSoundsSection != null ? new BlockSounds(blockSoundsSection) : null;
        ConfigurationSection blockLockerSection = section.getConfigurationSection("blocklocker");
        this.blockLocker = blockLockerSection != null ? new BlockLockerMechanic(blockLockerSection) : null;
    }

    public String getModel(ConfigurationSection section) {
        return this.model != null ? this.model : section.getString("Pack.model");
    }

    public boolean hasBlockSounds() {
        return this.blockSounds != null;
    }

    public BlockSounds getBlockSounds() {
        return this.blockSounds;
    }

    public boolean hasLimitedPlacing() {
        return this.limitedPlacing != null;
    }

    public LimitedPlacing getLimitedPlacing() {
        return this.limitedPlacing;
    }

    public boolean isSapling() {
        return this.saplingMechanic != null;
    }

    public SaplingMechanic getSaplingMechanic() {
        return this.saplingMechanic;
    }

    public boolean isTall() {
        return this.isTall;
    }

    public int getCustomVariation() {
        return this.customVariation;
    }

    public Drop getDrop() {
        return this.drop;
    }

    public boolean hasHardness() {
        return this.hardness != -1;
    }

    public int getHardness() {
        return this.hardness;
    }

    public boolean hasLight() {
        return this.light <= -1;
    }

    public int getLight() {
        return this.light;
    }

    public boolean hasRandomPlace() {
        return !this.randomPlaceBlock.isEmpty();
    }

    public List<String> getRandomPlaceBlock() {
        return this.randomPlaceBlock;
    }

    public BlockLockerMechanic getBlockLocker() {
        return this.blockLocker;
    }
}

