/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.storage;

import com.jeff_media.morepersistentdatatypes.DataType;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import dev.triumphteam.gui.builder.gui.StorageBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.StorageGui;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.BlockHelpers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class StorageMechanic {
    public static Set<Player> playerStorages = new HashSet<Player>();
    public static Map<Block, StorageGui> blockStorages = new HashMap<Block, StorageGui>();
    public static Map<Entity, StorageGui> frameStorages = new HashMap<Entity, StorageGui>();
    public static final NamespacedKey STORAGE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "storage");
    public static final NamespacedKey PERSONAL_STORAGE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "personal_storage");
    private final int rows;
    private final String title;
    private final StorageType type;
    private final String openSound;
    private final String closeSound;
    private final String openAnimation;
    private final String closeAnimation;
    private final float volume;
    private final float pitch;

    public StorageMechanic(ConfigurationSection section) {
        this.rows = section.getInt("rows", 6);
        this.title = section.getString("title", "Storage");
        this.type = StorageType.valueOf(section.getString("type", "STORAGE"));
        this.openSound = section.getString("open_sound", "minecraft:block.chest.open");
        this.closeSound = section.getString("close_sound", "minecraft:block.chest.close");
        this.openAnimation = section.getString("open_animation", null);
        this.closeAnimation = section.getString("close_animation", null);
        this.volume = (float)section.getDouble("volume", 0.5);
        this.pitch = (float)section.getDouble("pitch", (double)0.95f);
    }

    public void openPersonalStorage(Player player, Location location, @Nullable Entity baseEntity) {
        if (this.type != StorageType.PERSONAL) {
            return;
        }
        StorageGui storageGui = this.createPersonalGui(player, baseEntity);
        storageGui.open((HumanEntity)player);
        if (baseEntity != null) {
            this.playOpenAnimation(baseEntity, this.openAnimation);
        }
        if (this.hasOpenSound() && location.isWorldLoaded()) {
            Objects.requireNonNull(location.getWorld()).playSound(location, this.openSound, this.volume, this.pitch);
        }
    }

    public void openDisposal(Player player, Location location, @Nullable Entity baseEntity) {
        if (this.type != StorageType.DISPOSAL) {
            return;
        }
        StorageGui storageGui = this.createDisposalGui(location, baseEntity);
        storageGui.open((HumanEntity)player);
        if (baseEntity != null) {
            this.playOpenAnimation(baseEntity, this.openAnimation);
        }
        if (this.hasOpenSound() && location.isWorldLoaded()) {
            Objects.requireNonNull(location.getWorld()).playSound(location, this.openSound, this.volume, this.pitch);
        }
    }

    public void openStorage(Block block, Player player) {
        if (block.getType() != Material.NOTE_BLOCK) {
            return;
        }
        StorageGui storageGui = blockStorages.containsKey(block) ? blockStorages.get(block) : this.createGui(block, null);
        storageGui.open((HumanEntity)player);
        blockStorages.put(block, storageGui);
        if (this.hasOpenSound() && block.getLocation().isWorldLoaded()) {
            Objects.requireNonNull(block.getWorld()).playSound(block.getLocation(), this.openSound, this.volume, this.pitch);
        }
    }

    public void openStorage(Entity baseEntity, Player player) {
        StorageGui storageGui = frameStorages.containsKey(baseEntity) ? frameStorages.get(baseEntity) : this.createGui(baseEntity);
        storageGui.open((HumanEntity)player);
        frameStorages.put(baseEntity, storageGui);
        this.playOpenAnimation(baseEntity, this.openAnimation);
        if (this.hasOpenSound() && baseEntity.getLocation().isWorldLoaded()) {
            Objects.requireNonNull(baseEntity.getWorld()).playSound(baseEntity.getLocation(), this.openSound, this.volume, this.pitch);
        }
    }

    private void playOpenAnimation(Entity baseEntity, String animation) {
        ModeledEntity modelEntity;
        UUID uuid;
        if (baseEntity == null || animation == null) {
            return;
        }
        PersistentDataContainer pdc = baseEntity.getPersistentDataContainer();
        if (pdc.has(FurnitureMechanic.MODELENGINE_KEY, DataType.UUID) && (uuid = (UUID)pdc.get(FurnitureMechanic.MODELENGINE_KEY, DataType.UUID)) != null && (modelEntity = ModelEngineAPI.getModeledEntity((UUID)uuid)) != null) {
            for (ActiveModel model : modelEntity.getModels().values()) {
                model.getAnimationHandler().forceStopAllAnimations();
                model.getAnimationHandler().playAnimation(animation, 0.0, 0.0, 1.0, true);
            }
        }
    }

    public void dropStorageContent(Block block) {
        ItemStack[] items;
        StorageGui gui = blockStorages.get(block);
        PersistentDataContainer pdc = BlockHelpers.getPDC(block);
        ItemStack[] itemStackArray = items = blockStorages.containsKey(block) && gui != null ? gui.getInventory().getContents() : (ItemStack[])pdc.getOrDefault(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]);
        if (this.isShulker()) {
            NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
            if (mechanic == null) {
                return;
            }
            ItemStack shulker = OraxenItems.getItemById(mechanic.getItemID()).build();
            ItemMeta shulkerMeta = shulker.getItemMeta();
            if (shulkerMeta != null) {
                shulkerMeta.getPersistentDataContainer().set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)items);
            }
            shulker.setItemMeta(shulkerMeta);
            block.getWorld().dropItemNaturally(block.getLocation(), shulker);
        } else {
            for (ItemStack item : items) {
                if (item == null) continue;
                block.getWorld().dropItemNaturally(block.getLocation(), item);
            }
        }
        if (gui != null) {
            HumanEntity[] players;
            for (HumanEntity player : players = gui.getInventory().getViewers().toArray(new HumanEntity[0])) {
                gui.close(player);
            }
        }
        pdc.remove(STORAGE_KEY);
        blockStorages.remove(block);
    }

    public void dropStorageContent(FurnitureMechanic mechanic, Entity baseEntity) {
        ItemStack items;
        StorageGui gui = frameStorages.get(baseEntity);
        PersistentDataContainer pdc = baseEntity.getPersistentDataContainer();
        Object object = items = frameStorages.containsKey(baseEntity) && gui != null ? gui.getInventory().getContents() : (ItemStack[])pdc.getOrDefault(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]);
        if (this.isShulker()) {
            ItemStack defaultItem = OraxenItems.getItemById(mechanic.getItemID()).build();
            ItemStack shulker = FurnitureMechanic.getFurnitureItem(baseEntity);
            ItemMeta shulkerMeta = shulker.getItemMeta();
            if (shulkerMeta != null) {
                shulkerMeta.getPersistentDataContainer().set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)items);
                shulkerMeta.setDisplayName(defaultItem.getItemMeta() != null ? defaultItem.getItemMeta().getDisplayName() : null);
                shulker.setItemMeta(shulkerMeta);
            }
            baseEntity.getWorld().dropItemNaturally(baseEntity.getLocation(), shulker);
        } else {
            for (ItemStack item : items) {
                if (item == null) continue;
                baseEntity.getWorld().dropItemNaturally(baseEntity.getLocation(), item);
            }
        }
        if (gui != null) {
            HumanEntity[] players;
            for (HumanEntity player : players = gui.getInventory().getViewers().toArray(new HumanEntity[0])) {
                gui.close(player);
            }
        }
        pdc.remove(STORAGE_KEY);
        frameStorages.remove(baseEntity);
    }

    public int getRows() {
        return this.rows;
    }

    public String getTitle() {
        return this.title;
    }

    public StorageType getStorageType() {
        return this.type;
    }

    public boolean isStorage() {
        return this.type == StorageType.STORAGE;
    }

    public boolean isPersonal() {
        return this.type == StorageType.PERSONAL;
    }

    public boolean isEnderchest() {
        return this.type == StorageType.ENDERCHEST;
    }

    public boolean isDisposal() {
        return this.type == StorageType.DISPOSAL;
    }

    public boolean isShulker() {
        return this.type == StorageType.SHULKER;
    }

    public boolean hasOpenSound() {
        return this.openSound != null;
    }

    public String getOpenSound() {
        return this.openSound;
    }

    public boolean hasCloseSound() {
        return this.closeSound != null;
    }

    public String getCloseSound() {
        return this.closeSound;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    private StorageGui createDisposalGui(Location location, @Nullable Entity baseEntity) {
        StorageGui gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.title))).rows(this.rows)).create();
        gui.setOpenGuiAction(event -> gui.getInventory().clear());
        gui.setCloseGuiAction(event -> {
            gui.getInventory().clear();
            if (this.hasCloseSound() && location.isWorldLoaded()) {
                Objects.requireNonNull(location.getWorld()).playSound(location, this.closeSound, this.volume, this.pitch);
            }
            if (baseEntity != null) {
                this.playOpenAnimation(baseEntity, this.closeAnimation);
            }
        });
        return gui;
    }

    private StorageGui createPersonalGui(Player player, @Nullable Entity baseEntity) {
        PersistentDataContainer storagePDC = player.getPersistentDataContainer();
        StorageGui gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.title))).rows(this.rows)).create();
        gui.setDefaultClickAction(event -> {
            if (event.getCursor() != null && event.getCursor().getType() != Material.AIR || event.getCurrentItem() != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> storagePDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents()), 3L);
            }
        });
        gui.setOpenGuiAction(event -> {
            playerStorages.add(player);
            if (storagePDC.has(PERSONAL_STORAGE_KEY, DataType.ITEM_STACK_ARRAY)) {
                gui.getInventory().setContents(Objects.requireNonNull((ItemStack[])storagePDC.get(PERSONAL_STORAGE_KEY, DataType.ITEM_STACK_ARRAY)));
            }
        });
        gui.setCloseGuiAction(event -> {
            playerStorages.remove(player);
            storagePDC.set(PERSONAL_STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents());
            if (this.hasCloseSound() && player.getLocation().isWorldLoaded()) {
                Objects.requireNonNull(player.getLocation().getWorld()).playSound(player.getLocation(), this.closeSound, this.volume, this.pitch);
            }
            if (baseEntity != null) {
                this.playOpenAnimation(baseEntity, this.closeAnimation);
            }
        });
        return gui;
    }

    private StorageGui createGui(Block block, @Nullable ItemFrame frame) {
        Location location = block.getLocation();
        PersistentDataContainer storagePDC = BlockHelpers.getPDC(block);
        StorageGui gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.title))).rows(this.rows)).create();
        gui.setDefaultClickAction(event -> {
            if (event.getCursor() != null && event.getCursor().getType() != Material.AIR || event.getCurrentItem() != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> storagePDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents()), 3L);
            }
        });
        gui.setOpenGuiAction(event -> {
            if (storagePDC.has(STORAGE_KEY, DataType.ITEM_STACK_ARRAY)) {
                gui.getInventory().setContents((ItemStack[])storagePDC.getOrDefault(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]));
            }
        });
        gui.setCloseGuiAction(event -> {
            storagePDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents());
            if (this.hasCloseSound() && BlockHelpers.isLoaded(block.getLocation())) {
                Objects.requireNonNull(location.getWorld()).playSound(location, this.closeSound, this.volume, this.pitch);
            }
            if (frame != null) {
                this.playOpenAnimation((Entity)frame, this.closeAnimation);
            }
        });
        return gui;
    }

    private StorageGui createGui(Entity baseEntity) {
        Location location = baseEntity.getLocation();
        ItemStack furnitureItem = FurnitureMechanic.getFurnitureItem(baseEntity);
        if (furnitureItem == null) {
            return null;
        }
        PersistentDataContainer storagePDC = baseEntity.getPersistentDataContainer();
        PersistentDataContainer itemPDC = furnitureItem.getItemMeta().getPersistentDataContainer();
        boolean shulker = this.isShulker();
        PersistentDataContainer shulkerPDC = shulker ? itemPDC : null;
        StorageGui gui = ((StorageBuilder)((StorageBuilder)Gui.storage().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.title))).rows(this.rows)).create();
        gui.setDefaultClickAction(event -> {
            if (event.getCursor() != null && event.getCursor().getType() != Material.AIR || event.getCurrentItem() != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> storagePDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents()), 3L);
            }
        });
        gui.setOpenGuiAction(event -> gui.getInventory().setContents(!shulker && storagePDC.has(STORAGE_KEY, DataType.ITEM_STACK_ARRAY) ? (ItemStack[])storagePDC.getOrDefault(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]) : (shulker && shulkerPDC.has(STORAGE_KEY, DataType.ITEM_STACK_ARRAY) ? (ItemStack[])shulkerPDC.getOrDefault(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]) : new ItemStack[]{})));
        gui.setCloseGuiAction(event -> {
            if (gui.getInventory().getViewers().size() <= 1) {
                if (shulker) {
                    shulkerPDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents());
                } else {
                    storagePDC.set(STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)gui.getInventory().getContents());
                }
            }
            if (this.hasCloseSound() && BlockHelpers.isLoaded(baseEntity.getLocation())) {
                Objects.requireNonNull(location.getWorld()).playSound(location, this.closeSound, this.volume, this.pitch);
            }
            this.playOpenAnimation(baseEntity, this.closeAnimation);
        });
        return gui;
    }

    public static enum StorageType {
        STORAGE,
        PERSONAL,
        ENDERCHEST,
        DISPOSAL,
        SHULKER;

    }
}

