/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FarmBlockDryout {
    private static final NamespacedKey FARMBLOCK_MOIST = new NamespacedKey((Plugin)OraxenPlugin.get(), "farmblock_moist");
    private final String farmBlock;
    private final String moistFarmBlock;
    private final int farmBlockDryoutTime;
    private final String id;

    public FarmBlockDryout(String itemID, ConfigurationSection farmblockSection) {
        this.id = itemID;
        this.farmBlock = farmblockSection.getString("farmBlockPath");
        this.moistFarmBlock = farmblockSection.getString("moistFarmBlockPath");
        this.farmBlockDryoutTime = farmblockSection.getInt("farmBlockDryOutTime", 50000);
    }

    public int getDelay() {
        return this.getDryoutTime();
    }

    public boolean isFarmBlock() {
        return this.farmBlock != null || this.moistFarmBlock != null;
    }

    public byte getMoistureLevel(Block block) {
        if (!this.isMoistFarmBlock()) {
            return 0;
        }
        return (Byte)BlockHelpers.getPDC(block).getOrDefault(FARMBLOCK_MOIST, PersistentDataType.BYTE, (Object)0);
    }

    public boolean isMoistFarmBlock() {
        return (this.moistFarmBlock == null || this.moistFarmBlock.equals(this.id)) && this.farmBlock != null;
    }

    public String getFarmBlock() {
        return this.farmBlock;
    }

    public String getMoistFarmBlock() {
        return this.moistFarmBlock;
    }

    public int getDryoutTime() {
        return this.farmBlockDryoutTime;
    }

    private int getMoisture(Block block) {
        return switch (block.getType()) {
            case Material.WATER -> 5;
            case Material.FARMLAND -> {
                if (((Farmland)block.getBlockData()).getMoisture() > 0) {
                    yield 1;
                }
                yield 0;
            }
            case Material.NOTE_BLOCK -> {
                NoteBlockMechanic temp = OraxenBlocks.getNoteBlockMechanic(block);
                if (temp != null && temp.hasDryout()) {
                    yield temp.getDryout().getMoistureLevel(block);
                }
                yield 0;
            }
            default -> 0;
        };
    }

    public boolean isConnectedToWaterSource(Block block, PersistentDataContainer pdc) {
        Block x;
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(block.getRelative(BlockFace.DOWN));
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int z = -1; z < 2; ++z) {
                if (x2 == 0 && z == 0) continue;
                blocks.add(block.getRelative(x2, 0, z));
            }
        }
        int maxLevel = 0;
        Iterator z = blocks.iterator();
        while (z.hasNext() && (maxLevel = Math.max(maxLevel, this.getMoisture(x = (Block)z.next()))) != 5) {
        }
        int moistLevel = Math.max(0, maxLevel - 1);
        pdc.set(FARMBLOCK_MOIST, PersistentDataType.BYTE, (Object)((byte)moistLevel));
        return moistLevel > 0;
    }
}

