/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockInteractEvent;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockPlaceEvent;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.directional.DirectionalBlock;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import io.th0rgal.oraxen.utils.breaker.HardnessModifier;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class NoteBlockMechanicListener
implements Listener {
    public static Map<Instrument, List<String>> instrumentMap = new HashMap<Instrument, List<String>>();

    public NoteBlockMechanicListener() {
        BreakerSystem.MODIFIERS.add(this.getHardnessModifier());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void callInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.NOTE_BLOCK) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (!EventUtils.callEvent(new OraxenNoteBlockInteractEvent(mechanic, event.getPlayer(), event.getItem(), event.getHand(), block, event.getBlockFace()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLimitedPlacing(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace blockFace = event.getBlockFace();
        ItemStack item = event.getItem();
        if (item == null || block == null || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(OraxenItems.getIdByItem(item));
        if (mechanic == null || !mechanic.hasLimitedPlacing()) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(block)) {
            return;
        }
        LimitedPlacing limitedPlacing = mechanic.getLimitedPlacing();
        Block belowPlaced = block.getRelative(blockFace).getRelative(BlockFace.DOWN);
        if (limitedPlacing.isNotPlacableOn(block, blockFace)) {
            event.setCancelled(true);
        } else if (limitedPlacing.isRadiusLimited()) {
            LimitedPlacing.RadiusLimitation radiusLimitation = limitedPlacing.getRadiusLimitation();
            int rad = radiusLimitation.getRadius();
            int amount = radiusLimitation.getAmount();
            int count = 0;
            for (int x = -rad; x <= rad; ++x) {
                for (int y = -rad; y <= rad; ++y) {
                    for (int z = -rad; z <= rad; ++z) {
                        NoteBlockMechanic relativeMechanic = OraxenBlocks.getNoteBlockMechanic(block.getRelative(x, y, z));
                        if (relativeMechanic == null || !relativeMechanic.getItemID().equals(mechanic.getItemID())) continue;
                        ++count;
                    }
                }
            }
            if (count >= amount) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.ALLOW) {
            if (!limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.DENY && limitedPlacing.checkLimitedMechanic(belowPlaced)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteractNoteBlock(OraxenNoteBlockInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        NoteBlockMechanic mechanic = event.getMechanic();
        if (!ProtectionLib.canInteract((Player)player, (Location)block.getLocation())) {
            return;
        }
        if (!player.isSneaking()) {
            if (mechanic.hasClickActions()) {
                mechanic.runClickActions(player);
                event.setCancelled(true);
            }
            if (mechanic.isStorage()) {
                StorageMechanic storageMechanic = mechanic.getStorage();
                switch (storageMechanic.getStorageType()) {
                    case STORAGE: 
                    case SHULKER: {
                        storageMechanic.openStorage(block, player);
                        break;
                    }
                    case PERSONAL: {
                        storageMechanic.openPersonalStorage(player, block.getLocation(), null);
                        break;
                    }
                    case DISPOSAL: {
                        storageMechanic.openDisposal(player, block.getLocation(), null);
                        break;
                    }
                    case ENDERCHEST: {
                        player.openInventory(player.getEnderChest());
                    }
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlaceAgainstNoteBlock(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        EquipmentSlot hand = event.getHand();
        BlockFace blockFace = event.getBlockFace();
        if (hand == null || event.getAction() != Action.RIGHT_CLICK_BLOCK || block == null || block.getType() != Material.NOTE_BLOCK) {
            return;
        }
        if (!player.isSneaking() && BlockHelpers.isInteractable(block)) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
            mechanic = mechanic.getDirectional().getParentMechanic();
        }
        event.setUseInteractedBlock(Event.Result.DENY);
        if (OraxenBlocks.isOraxenNoteBlock(item)) {
            return;
        }
        if (!EventUtils.callEvent(new OraxenNoteBlockInteractEvent(mechanic, player, item, hand, block, blockFace))) {
            event.setCancelled(true);
        }
        if (item == null) {
            return;
        }
        Material type = item.getType();
        if (type == Material.AIR) {
            return;
        }
        BlockData newData = type.isBlock() ? type.createBlockData() : null;
        this.makePlayerPlaceBlock(player, event.getHand(), item, block, event.getBlockFace(), newData);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPrePlacingCustomBlock(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        Player player = event.getPlayer();
        Block placedAgainst = event.getClickedBlock();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || placedAgainst == null) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(itemID);
        if (mechanic == null) {
            return;
        }
        if (!player.isSneaking() && BlockHelpers.isInteractable(placedAgainst)) {
            return;
        }
        int customVariation = mechanic.getCustomVariation();
        boolean isFalling = mechanic.isFalling();
        BlockFace face = event.getBlockFace();
        if (mechanic.isDirectional()) {
            DirectionalBlock directional = mechanic.getDirectional();
            if (!directional.isParentBlock()) {
                directional = directional.getParentMechanic().getDirectional();
            }
            customVariation = directional.getDirectionVariation(face, player);
        }
        NoteBlock data = NoteBlockMechanicFactory.createNoteBlockData(customVariation);
        this.makePlayerPlaceBlock(player, event.getHand(), event.getItem(), placedAgainst, face, (BlockData)data);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onNotePlayed(NotePlayEvent event) {
        if (event.getInstrument() != Instrument.PIANO) {
            event.setCancelled(true);
        } else {
            if (instrumentMap.isEmpty()) {
                instrumentMap = NoteBlockMechanicListener.getInstrumentMap();
            }
            String blockType = event.getBlock().getRelative(BlockFace.DOWN).getType().toString().toLowerCase();
            Instrument fakeInstrument = instrumentMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(blockType)).map(Map.Entry::getKey).findFirst().orElse(Instrument.PIANO);
            event.setInstrument(fakeInstrument);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakingCustomBlock(BlockBreakEvent event) {
        if (OraxenBlocks.remove(event.getBlock().getLocation(), event.getPlayer())) {
            event.setDropItems(false);
        }
    }

    @EventHandler
    public void onExplosionDestroy(EntityExplodeEvent event) {
        for (Block block : new HashSet(event.blockList())) {
            if (!OraxenBlocks.isOraxenNoteBlock(block)) continue;
            OraxenBlocks.remove(block.getLocation(), null);
            event.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFallingOraxenBlock(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            BlockData blockData = fallingBlock.getBlockData();
            NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(blockData);
            if (mechanic == null) {
                return;
            }
            OraxenBlocks.place(mechanic.getItemID(), event.getBlock().getLocation());
            fallingBlock.setDropItem(false);
        }
    }

    @EventHandler
    public void onBreakBeneathFallingOraxenBlock(BlockBreakEvent event) {
        this.handleFallingOraxenBlockAbove(event.getBlock());
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSetFire(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (block == null || block.getType() != Material.NOTE_BLOCK) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getBlockFace() != BlockFace.UP) {
            return;
        }
        if (item == null) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (!mechanic.canIgnite()) {
            return;
        }
        if (item.getType() != Material.FLINT_AND_STEEL && item.getType() != Material.FIRE_CHARGE) {
            return;
        }
        EventUtils.callEvent((Event)new BlockIgniteEvent(block, BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL, (Entity)event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCatchFire(BlockIgniteEvent event) {
        Block block = event.getBlock();
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (block.getType() != Material.NOTE_BLOCK || mechanic == null) {
            return;
        }
        if (!mechanic.canIgnite()) {
            event.setCancelled(true);
        }
        block.getWorld().playSound(block.getLocation(), Sound.ITEM_FLINTANDSTEEL_USE, 1.0f, 1.0f);
        block.getRelative(BlockFace.UP).setType(Material.FIRE);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlacingBlock(BlockPlaceEvent event) {
        Block placed = event.getBlockPlaced();
        if (placed.getType() != Material.NOTE_BLOCK) {
            return;
        }
        if (OraxenBlocks.isOraxenNoteBlock(OraxenItems.getIdByItem(event.getItemInHand()))) {
            return;
        }
        placed.setBlockData(Bukkit.createBlockData((Material)Material.NOTE_BLOCK), false);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMiddleClick(InventoryCreativeEvent event) {
        if (event.getClick() != ClickType.CREATIVE) {
            return;
        }
        Player player = (Player)event.getInventory().getHolder();
        if (player == null) {
            return;
        }
        if (event.getCursor().getType() == Material.NOTE_BLOCK) {
            RayTraceResult rayTraceResult = player.rayTraceBlocks(6.0);
            if (rayTraceResult == null) {
                return;
            }
            Block block = rayTraceResult.getHitBlock();
            if (block == null) {
                return;
            }
            NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
            if (mechanic == null) {
                return;
            }
            ItemStack item = mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock() ? OraxenItems.getItemById(mechanic.getDirectional().getParentBlock()).build() : OraxenItems.getItemById(mechanic.getItemID()).build();
            for (int i = 0; i <= 8; ++i) {
                if (player.getInventory().getItem(i) == null || !Objects.equals(OraxenItems.getIdByItem(player.getInventory().getItem(i)), OraxenItems.getIdByItem(item))) continue;
                player.getInventory().setHeldItemSlot(i);
                event.setCancelled(true);
                return;
            }
            event.setCursor(item);
        }
    }

    private void handleFallingOraxenBlockAbove(Block block) {
        Block blockAbove = block.getRelative(BlockFace.UP);
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(blockAbove);
        if (mechanic == null || !mechanic.isFalling()) {
            return;
        }
        Location fallingLocation = BlockHelpers.toCenterBlockLocation(blockAbove.getLocation());
        BlockData fallingData = OraxenBlocks.getOraxenBlockData(mechanic.getItemID());
        if (fallingData == null) {
            return;
        }
        OraxenBlocks.remove(blockAbove.getLocation(), null);
        blockAbove.getWorld().spawnFallingBlock(fallingLocation, fallingData);
        this.handleFallingOraxenBlockAbove(blockAbove);
    }

    private HardnessModifier getHardnessModifier() {
        return new HardnessModifier(){

            @Override
            public boolean isTriggered(Player player, Block block, ItemStack tool) {
                if (block.getType() != Material.NOTE_BLOCK) {
                    return false;
                }
                NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (mechanic == null) {
                    return false;
                }
                if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
                    mechanic = mechanic.getDirectional().getParentMechanic();
                }
                return mechanic.hasHardness();
            }

            @Override
            public void breakBlock(Player player, Block block, ItemStack tool) {
                block.setType(Material.AIR);
            }

            @Override
            public long getPeriod(Player player, Block block, ItemStack tool) {
                NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (mechanic == null) {
                    return 0L;
                }
                if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
                    mechanic = mechanic.getDirectional().getParentMechanic();
                }
                long period = mechanic.getHardness();
                double modifier = 1.0;
                if (mechanic.getDrop().canDrop(tool)) {
                    modifier *= 0.4;
                    int diff = mechanic.getDrop().getDiff(tool);
                    if (diff >= 1) {
                        modifier *= Math.pow(0.9, diff);
                    }
                }
                return (long)((double)period * modifier);
            }
        };
    }

    public void makePlayerPlaceBlock(Player player, EquipmentSlot hand, ItemStack item, Block placedAgainst, BlockFace face, BlockData newData) {
        NoteBlockMechanic targetOraxen;
        Block target;
        Material type = placedAgainst.getType();
        if (BlockHelpers.isReplaceable(type)) {
            target = placedAgainst;
        } else {
            target = placedAgainst.getRelative(face);
            if (!BlockHelpers.isReplaceable(target.getType())) {
                return;
            }
        }
        NoteBlockMechanic againstMechanic = OraxenBlocks.getNoteBlockMechanic(placedAgainst);
        BlockData oldData = target.getBlockData();
        if (newData != null) {
            target.setBlockData(newData);
            BlockPlaceEvent blockPlaceEvent = new BlockPlaceEvent(target, target.getState(), placedAgainst, item, player, true, hand);
            if (againstMechanic != null && (againstMechanic.isStorage() || againstMechanic.hasClickActions())) {
                blockPlaceEvent.setCancelled(true);
            }
            if (BlockHelpers.isStandingInside(player, target) || !ProtectionLib.canBuild((Player)player, (Location)target.getLocation())) {
                blockPlaceEvent.setCancelled(true);
            }
            if (!Range.between((Comparable)Integer.valueOf(target.getWorld().getMinHeight()), (Comparable)Integer.valueOf(target.getWorld().getMaxHeight() - 1)).contains((Object)target.getY())) {
                blockPlaceEvent.setCancelled(true);
            }
            if (!EventUtils.callEvent((Event)blockPlaceEvent) || !blockPlaceEvent.canBuild()) {
                target.setBlockData(oldData);
                return;
            }
        }
        if ((targetOraxen = OraxenBlocks.getNoteBlockMechanic(newData)) != null) {
            OraxenBlocks.place(targetOraxen.getItemID(), target.getLocation());
            OraxenNoteBlockPlaceEvent oraxenPlaceEvent = new OraxenNoteBlockPlaceEvent(targetOraxen, target, player, item, hand);
            if (!EventUtils.callEvent(oraxenPlaceEvent)) {
                target.setBlockData(oldData);
                return;
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
            Utils.swingHand(player, hand);
        } else {
            target.setType(Material.AIR);
            BlockHelpers.correctAllBlockStates(placedAgainst, player, hand, face, item, newData);
        }
    }

    private static Map<Instrument, List<String>> getInstrumentMap() {
        HashMap<Instrument, List<String>> map = new HashMap<Instrument, List<String>>();
        map.put(Instrument.BELL, List.of("gold_block"));
        map.put(Instrument.BASS_DRUM, Arrays.asList("stone", "netherrack", "bedrock", "observer", "coral", "obsidian", "anchor", "quartz"));
        map.put(Instrument.FLUTE, List.of("clay"));
        map.put(Instrument.CHIME, List.of("packed_ice"));
        map.put(Instrument.GUITAR, List.of("wool"));
        map.put(Instrument.XYLOPHONE, List.of("bone_block"));
        map.put(Instrument.IRON_XYLOPHONE, List.of("iron_block"));
        map.put(Instrument.COW_BELL, List.of("soul_sand"));
        map.put(Instrument.DIDGERIDOO, List.of("pumpkin"));
        map.put(Instrument.BIT, List.of("emerald_block"));
        map.put(Instrument.BANJO, List.of("hay_bale"));
        map.put(Instrument.PLING, List.of("glowstone"));
        map.put(Instrument.BASS_GUITAR, List.of("wood"));
        map.put(Instrument.SNARE_DRUM, Arrays.asList("sand", "gravel", "concrete_powder", "soul_soil"));
        map.put(Instrument.STICKS, Arrays.asList("glass", "sea_lantern", "beacon"));
        return map;
    }

    public static class NoteBlockMechanicPhysicsListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPistonPush(BlockPistonExtendEvent event) {
            if (event.getBlocks().stream().anyMatch(block -> block.getType().equals((Object)Material.NOTE_BLOCK))) {
                event.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPistonPull(BlockPistonRetractEvent event) {
            if (event.getBlocks().stream().anyMatch(block -> block.getType().equals((Object)Material.NOTE_BLOCK))) {
                event.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onBlockPhysics(BlockPhysicsEvent event) {
            Block block = event.getBlock();
            Block aboveBlock = block.getRelative(BlockFace.UP);
            Block belowBlock = block.getRelative(BlockFace.DOWN);
            if (belowBlock.getType() == Material.NOTE_BLOCK) {
                event.setCancelled(true);
                this.updateAndCheck(belowBlock);
            } else if (aboveBlock.getType() == Material.NOTE_BLOCK) {
                event.setCancelled(true);
                this.updateAndCheck(aboveBlock);
            }
            if (block.getType() == Material.NOTE_BLOCK) {
                event.setCancelled(true);
                this.updateAndCheck(block);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST)
        public void onNoteblockPowered(GenericGameEvent event) {
            Block block = event.getLocation().getBlock();
            Location eLoc = block.getLocation();
            if (!BlockHelpers.isLoaded(event.getLocation()) || !BlockHelpers.isLoaded(eLoc)) {
                return;
            }
            if (!VersionUtil.atOrAbove("1.19")) {
                return;
            }
            if (event.getEvent() != GameEvent.NOTE_BLOCK_PLAY) {
                return;
            }
            if (block.getType() != Material.NOTE_BLOCK) {
                return;
            }
            NoteBlock data = (NoteBlock)block.getBlockData().clone();
            Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> block.setBlockData((BlockData)data, false), 1L);
        }

        public void updateAndCheck(Block block) {
            Block nextBlock;
            Block blockAbove = block.getRelative(BlockFace.UP);
            if (blockAbove.getType() == Material.NOTE_BLOCK) {
                blockAbove.getState().update(true, true);
            }
            if ((nextBlock = blockAbove.getRelative(BlockFace.UP)).getType() == Material.NOTE_BLOCK) {
                this.updateAndCheck(blockAbove);
            }
        }
    }

    public static class NoteBlockMechanicPaperListener
    implements Listener {
        @EventHandler
        public void onFallingBlockLandOnCarpet(EntityRemoveFromWorldEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof FallingBlock)) {
                return;
            }
            FallingBlock fallingBlock = (FallingBlock)entity;
            NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(fallingBlock.getBlockData());
            if (mechanic == null || Objects.equals(OraxenBlocks.getOraxenBlock(fallingBlock.getLocation()), mechanic)) {
                return;
            }
            if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
                mechanic = mechanic.getDirectional().getParentMechanic();
            }
            ItemStack itemStack = OraxenItems.getItemById(mechanic.getItemID()).build();
            fallingBlock.setDropItem(false);
            fallingBlock.getWorld().dropItemNaturally(fallingBlock.getLocation(), itemStack);
        }
    }
}

