/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution;

import java.util.Random;
import org.bukkit.configuration.ConfigurationSection;

public class EvolvingFurniture {
    private final String currentStage;
    private final int delay;
    private final boolean isLightBoost;
    private int minimumLightLevel;
    private int lightBoostTick;
    private final boolean isRainBoost;
    private int rainBoostTick;
    private final boolean isBoneMeal;
    private int boneMealChance;
    private final String nextStage;
    private final int probability;
    private final Random random = new Random();

    public EvolvingFurniture(String itemID, ConfigurationSection plantSection) {
        ConfigurationSection section;
        this.currentStage = itemID;
        this.delay = plantSection.getInt("delay");
        if (plantSection.isConfigurationSection("light_boost")) {
            section = plantSection.getConfigurationSection("light_boost");
            this.isLightBoost = true;
            this.minimumLightLevel = section.getInt("minimum_light_level");
            this.lightBoostTick = section.getInt("boost_tick");
        } else {
            this.isLightBoost = false;
        }
        if (plantSection.isConfigurationSection("rain_boost")) {
            section = plantSection.getConfigurationSection("rain_boost");
            this.isRainBoost = true;
            this.rainBoostTick = section.getInt("boost_tick");
        } else {
            this.isRainBoost = false;
        }
        if (plantSection.isConfigurationSection("bone_meal")) {
            section = plantSection.getConfigurationSection("bone_meal");
            this.isBoneMeal = true;
            this.boneMealChance = section.getInt("chance") > 100 ? 100 : Math.max(section.getInt("chance"), 0);
        } else {
            this.isBoneMeal = false;
        }
        this.nextStage = plantSection.getString("next_stage");
        this.probability = (int)(1.0 / (Double)plantSection.get("probability", (Object)1));
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isLightBoosted() {
        return this.isLightBoost;
    }

    public int getMinimumLightLevel() {
        return this.minimumLightLevel;
    }

    public int getLightBoostTick() {
        return this.lightBoostTick;
    }

    public boolean isRainBoosted() {
        return this.isRainBoost;
    }

    public int getRainBoostTick() {
        return this.rainBoostTick;
    }

    public boolean isBoneMeal() {
        return this.isBoneMeal;
    }

    public int getBoneMealChance() {
        return this.boneMealChance;
    }

    public String getCurrentStage() {
        return this.currentStage;
    }

    public String getNextStage() {
        return this.nextStage;
    }

    public boolean bernoulliTest() {
        return this.random.nextInt(this.probability) == 0;
    }
}

