/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.jeff_media.customblockdata.CustomBlockData;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FurniturePaperListener
implements Listener {
    @EventHandler
    public void onFurnitureRemoval(EntityRemoveFromWorldEvent event) {
        Entity entity = event.getEntity();
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        if (mechanic == null) {
            return;
        }
        Entity baseEntity = mechanic.getBaseEntity(entity);
        List<Block> barriers = mechanic.getBarriers().stream().map(b -> entity.getLocation().add(b.toLocation(entity.getWorld())).getBlock()).toList();
        Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> {
            if (baseEntity == null) {
                if (!entity.isDead()) {
                    entity.remove();
                }
                barriers.forEach(b -> {
                    if (b.getType() == Material.BARRIER) {
                        b.setType(Material.AIR);
                        new CustomBlockData(b, (Plugin)OraxenPlugin.get()).clear();
                    }
                });
            }
        }, 1L);
    }
}

