/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanicFactory;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class EfficiencyMechanicListener
implements Listener {
    public EfficiencyMechanicListener(final MechanicFactory factory) {
        EfficiencyMechanicFactory factory1 = (EfficiencyMechanicFactory)factory;
        PacketAdapter listener = new PacketAdapter((Plugin)OraxenPlugin.get(), ListenerPriority.LOW, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

            public void onPacketReceiving(PacketEvent event) {
                EnumWrappers.PlayerDigType type;
                PacketContainer packet = event.getPacket();
                Player player = event.getPlayer();
                if (player.getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                ItemStack item = player.getInventory().getItemInMainHand();
                String itemID = OraxenItems.getIdByItem(item);
                if (factory.isNotImplementedIn(itemID)) {
                    return;
                }
                EfficiencyMechanic mechanic = (EfficiencyMechanic)factory.getMechanic(itemID);
                StructureModifier data = packet.getEnumModifier(EnumWrappers.PlayerDigType.class, 2);
                try {
                    type = (EnumWrappers.PlayerDigType)data.getValues().get(0);
                }
                catch (IllegalArgumentException exception) {
                    type = EnumWrappers.PlayerDigType.SWAP_HELD_ITEMS;
                }
                if (type == EnumWrappers.PlayerDigType.START_DESTROY_BLOCK) {
                    Bukkit.getScheduler().runTask((Plugin)OraxenPlugin.get(), () -> player.addPotionEffect(new PotionEffect(mechanic.getType(), 6000, mechanic.getAmount() - 1, false, false, false)));
                } else {
                    Bukkit.getScheduler().runTask((Plugin)OraxenPlugin.get(), () -> player.removePotionEffect(mechanic.getType()));
                }
            }
        };
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)listener);
    }
}

