/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.farming.harvesting;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.harvesting.HarvestingMechanic;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.timers.Timer;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class HarvestingMechanicListener
implements Listener {
    private final MechanicFactory factory;

    public HarvestingMechanicListener(MechanicFactory factory) {
        this.factory = factory;
    }

    private static List<Block> getNearbyBlocks(Location location, int radius, int height) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = location.getBlockX() - Math.floorDiv(radius, 2); x <= location.getBlockX() + Math.floorDiv(radius, 2); ++x) {
            for (int y = location.getBlockY() - Math.floorDiv(height, 2); y <= location.getBlockY() + Math.floorDiv(height, 2); ++y) {
                for (int z = location.getBlockZ() - Math.floorDiv(radius, 2); z <= location.getBlockZ() + Math.floorDiv(radius, 2); ++z) {
                    blocks.add(Objects.requireNonNull(location.getWorld()).getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block clickedBlock = event.getClickedBlock();
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        String itemID = OraxenItems.getIdByItem(item);
        Player player = event.getPlayer();
        HarvestingMechanic mechanic = (HarvestingMechanic)this.factory.getMechanic(itemID);
        if (event.getHand() != EquipmentSlot.HAND || !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (clickedBlock == null || this.factory.isNotImplementedIn(itemID) || mechanic == null) {
            return;
        }
        Timer playerTimer = mechanic.getTimer(player);
        if (!playerTimer.isFinished()) {
            mechanic.getTimer(player).sendToPlayer(player);
            return;
        }
        playerTimer.reset();
        int durabilityDamage = 0;
        List<Block> nearbyBlocks = HarvestingMechanicListener.getNearbyBlocks(clickedBlock.getLocation(), mechanic.getRadius(), mechanic.getHeight());
        for (Block block : nearbyBlocks) {
            Ageable ageable;
            BlockData blockData = block.getBlockData();
            if (!(blockData instanceof Ageable) || (ageable = (Ageable)blockData).getAge() != ageable.getMaximumAge() || !ProtectionLib.canBreak((Player)player, (Location)block.getLocation()) || !ProtectionLib.canBuild((Player)player, (Location)block.getLocation())) continue;
            ageable.setAge(0);
            block.setBlockData((BlockData)ageable);
            SoundGroup soundGroup = block.getBlockData().getSoundGroup();
            block.getWorld().playSound(block.getLocation(), soundGroup.getBreakSound(), soundGroup.getVolume(), soundGroup.getPitch());
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            switch (block.getType()) {
                case WHEAT: {
                    drops.add(new ItemStack(Material.WHEAT));
                    drops.add(new ItemStack(Material.WHEAT_SEEDS));
                    break;
                }
                case BEETROOTS: {
                    drops.add(new ItemStack(Material.BEETROOT));
                    drops.add(new ItemStack(Material.BEETROOT_SEEDS));
                    break;
                }
                default: {
                    drops.addAll(block.getDrops());
                }
            }
            for (ItemStack itemStack : drops) {
                this.giveItem(player, itemStack, clickedBlock.getLocation());
            }
            ++durabilityDamage;
        }
        if (mechanic.shouldLowerItemDurability() && item.getItemMeta() instanceof Damageable && durabilityDamage > 0) {
            EventUtils.callEvent((Event)new PlayerItemDamageEvent(player, item, durabilityDamage));
        }
    }

    private void giveItem(Player player, ItemStack item, Location location) {
        if (player.getInventory().firstEmpty() != -1) {
            for (Map.Entry itemStack : player.getInventory().addItem(new ItemStack[]{item}).entrySet()) {
                player.getWorld().dropItem(player.getLocation(), (ItemStack)itemStack.getValue());
            }
        } else {
            player.getWorld().dropItemNaturally(location, item);
        }
    }
}

