/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.farming.bottledexp;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.mechanics.provided.farming.bottledexp.BottledExpMechanic;
import io.th0rgal.oraxen.mechanics.provided.farming.bottledexp.BottledExpMechanicFactory;
import io.th0rgal.oraxen.utils.EventUtils;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;

public class BottledExpMechanicListener
implements Listener {
    private final BottledExpMechanicFactory factory;

    public BottledExpMechanicListener(BottledExpMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        Action action = event.getAction();
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        Player player = event.getPlayer();
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (item == null || this.factory.isNotImplementedIn(itemID)) {
            return;
        }
        BottledExpMechanic mechanic = (BottledExpMechanic)this.factory.getMechanic(itemID);
        if (mechanic == null) {
            return;
        }
        ItemStack bottlesStack = new ItemStack(Material.EXPERIENCE_BOTTLE, mechanic.getBottleEquivalent(player.getLevel(), player.getExp()));
        if (bottlesStack.getAmount() > 0) {
            player.getWorld().dropItem(player.getLocation(), bottlesStack);
            player.setLevel(0);
            player.setExp(0.0f);
            EventUtils.callEvent((Event)new PlayerItemDamageEvent(player, item, this.factory.getDurabilityCost()));
        } else {
            Message.NOT_ENOUGH_EXP.send((CommandSender)player, new TagResolver[0]);
        }
    }
}

