/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.farming.bigmining;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.farming.bigmining.BigMiningMechanic;
import io.th0rgal.oraxen.mechanics.provided.farming.bigmining.BigMiningMechanicListener;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.logs.Logs;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public class BigMiningMechanicFactory
extends MechanicFactory {
    private final boolean callEvents;

    public BigMiningMechanicFactory(ConfigurationSection section) {
        super(section);
        if (Bukkit.getPluginManager().isPluginEnabled("AdvancedEnchantments") && section.getBoolean("call_events", true)) {
            Logs.logError("AdvancedEnchantment is enabled, disabling BigMining-Mechanic");
            section.set("call_events", (Object)false);
            OraxenYaml.saveConfig(OraxenPlugin.get().getDataFolder().toPath().resolve("mechanics.yml").toFile(), section);
            this.callEvents = false;
        } else {
            this.callEvents = section.getBoolean("call_events", true);
        }
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new BigMiningMechanicListener(this));
    }

    @Override
    public Mechanic parse(ConfigurationSection itemMechanicConfiguration) {
        BigMiningMechanic mechanic = new BigMiningMechanic(this, itemMechanicConfiguration);
        this.addToImplemented(mechanic);
        return mechanic;
    }

    public boolean callEvents() {
        return this.callEvents;
    }
}

