/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.cosmetic.aura;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.aura.Aura;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.aura.HelixAura;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.aura.RingAura;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.aura.SimpleAura;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AuraMechanic
extends Mechanic {
    public final Set<Player> players;
    public final Particle particle;
    private final Aura aura;

    public AuraMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.particle = Particle.valueOf((String)section.getString("particle"));
        switch (section.getString("type")) {
            case "simple": {
                this.aura = new SimpleAura(this);
                break;
            }
            case "ring": {
                this.aura = new RingAura(this);
                break;
            }
            case "helix": {
                this.aura = new HelixAura(this);
                break;
            }
            default: {
                this.aura = null;
            }
        }
        this.players = new HashSet<Player>();
    }

    public void add(Player player) {
        this.players.add(player);
        if (this.players.size() == 1) {
            this.aura.start();
        }
    }

    public void remove(Player player) {
        this.players.remove(player);
        if (this.players.isEmpty()) {
            this.aura.stop();
        }
    }
}

