/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.hud;

import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.hud.Hud;
import io.th0rgal.oraxen.hud.HudManager;
import org.bukkit.GameMode;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataContainer;

public class HudEvents
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        HudManager hudManager = OraxenPlugin.get().getHudManager();
        Player player = event.getPlayer();
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        Hud hud = hudManager.getActiveHudForPlayer(player) != null ? hudManager.getActiveHudForPlayer(player) : (Hud)hudManager.getDefaultEnabledHuds().stream().findFirst().orElse(null);
        String hudId = hudManager.getHudID(hud);
        if (hud == null || hudId == null) {
            return;
        }
        if (!player.hasPermission(hud.getPerm())) {
            return;
        }
        if (!hudManager.getHudStateForPlayer(player)) {
            return;
        }
        pdc.set(hudManager.hudDisplayKey, DataType.STRING, (Object)hudManager.getHudID(hud));
        pdc.set(hudManager.hudToggleKey, DataType.BOOLEAN, (Object)true);
        hudManager.updateHud(player);
    }

    @EventHandler
    public void onEnterWater(EntityAirChangeEvent event) {
        Player player;
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        HudManager hudManager = OraxenPlugin.get().getHudManager();
        Hud hud = hudManager.getActiveHudForPlayer(player = (Player)event.getEntity());
        if (hud == null || !hud.isDisabledWhilstInWater() || !hudManager.getHudStateForPlayer(player)) {
            return;
        }
        if (event.getAmount() < player.getMaximumAir()) {
            hudManager.setHudStateForPlayer(player, true);
            hudManager.updateHud(player);
        } else {
            hudManager.setHudStateForPlayer(player, false);
            hudManager.disableHud(player);
        }
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player;
        HudManager hudManager = OraxenPlugin.get().getHudManager();
        Hud hud = hudManager.getActiveHudForPlayer(player = event.getPlayer());
        if (hud == null) {
            return;
        }
        if (player.getGameMode() == GameMode.SPECTATOR && !hud.enableInSpectatorMode()) {
            hudManager.setHudStateForPlayer(player, false);
            hudManager.disableHud(player);
        } else {
            hudManager.setHudStateForPlayer(player, true);
            hudManager.updateHud(player);
        }
    }
}

