/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.gestures;

import com.ticxo.playeranimator.api.PlayerAnimator;
import com.ticxo.playeranimator.api.animation.pack.AnimationPack;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.gestures.GestureListener;
import io.th0rgal.oraxen.gestures.OraxenPlayerModel;
import io.th0rgal.oraxen.gestures.QuitMethod;
import io.th0rgal.oraxen.utils.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GestureManager {
    private final Map<Player, OraxenPlayerModel> gesturingPlayers = new HashMap<Player, OraxenPlayerModel>();
    public static Set<String> gestures = new HashSet<String>();

    public GestureManager() {
        if (Settings.GESTURES_ENABLED.toBool().booleanValue()) {
            this.loadGestures();
            Bukkit.getPluginManager().registerEvents((Listener)new GestureListener(this), (Plugin)OraxenPlugin.get());
        }
    }

    public void playGesture(Player player, String gesture) {
        if (this.isPlayerGesturing(player)) {
            return;
        }
        OraxenPlayerModel model = new OraxenPlayerModel(player, QuitMethod.SNEAK, false, false);
        this.addPlayerToGesturing(player, model);
        model.playAnimation(gesture);
    }

    public void stopGesture(Player player) {
        OraxenPlayerModel model = this.getPlayerModel(player);
        if (model == null) {
            return;
        }
        this.removePlayerFromGesturing(player);
        model.despawn();
    }

    public boolean isPlayerGesturing(Player player) {
        return this.gesturingPlayers.containsKey(player);
    }

    public OraxenPlayerModel getPlayerModel(Player player) {
        return this.gesturingPlayers.getOrDefault(player, null);
    }

    public void addPlayerToGesturing(Player player, OraxenPlayerModel gesture) {
        this.gesturingPlayers.put(player, gesture);
    }

    public void removePlayerFromGesturing(Player player) {
        this.gesturingPlayers.remove(player);
    }

    public void loadGestures() {
        PlayerAnimator.api.getAnimationManager().clearRegistry();
        gestures.clear();
        File gestureDir = new File(OraxenPlugin.get().getDataFolder().getPath() + "/gestures/");
        if (!gestureDir.exists()) {
            return;
        }
        File[] gestureFiles = gestureDir.listFiles();
        if (gestureFiles == null || gestureFiles.length == 0) {
            return;
        }
        if ((gestureFiles = (File[])Arrays.stream(gestureFiles).filter(f -> f.getPath().endsWith(".bbmodel")).distinct().toArray(File[]::new)).length == 0) {
            return;
        }
        for (File animationFile : gestureFiles) {
            String animationKey = Utils.removeExtension(animationFile.getName());
            PlayerAnimator.api.getAnimationManager().importAnimations(animationKey, animationFile);
        }
        for (Map.Entry entry : PlayerAnimator.api.getAnimationManager().getRegistry().entrySet()) {
            Set animationNames = ((AnimationPack)entry.getValue()).getAnimations().keySet().stream().map(animation -> ((String)packEntry.getKey()).replace(":", ".") + "." + animation).collect(Collectors.toSet());
            gestures.addAll(animationNames);
        }
    }

    public static Set<String> getGestures() {
        return gestures;
    }

    public void reload() {
        for (Map.Entry<Player, OraxenPlayerModel> entry : this.gesturingPlayers.entrySet()) {
            this.stopGesture(entry.getKey());
            this.gesturingPlayers.remove(entry.getKey());
        }
        this.loadGestures();
    }

    public Map<String, String> getPlayerHeadJsons() {
        return Map.of("assets/minecraft/models/required/player/norm/arm.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1,-2,10],\"scale\":[0.46875,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/norm/left_shoulder.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1.625,-2,11.5],\"scale\":[0.46875,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/norm/right_shoulder.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-0.375,-2,11.5],\"scale\":[0.46875,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/slim/arm.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1,-2,10],\"scale\":[0.3515625,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/slim/left_shoulder.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1.40625,-2,11.5],\"scale\":[0.3515625,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/slim/right_shoulder.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-0.59375,-2,11.5],\"scale\":[0.3515625,0.703125,0.46875]}}}", "assets/minecraft/models/required/player/body.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1,-2,13.75],\"scale\":[0.9375,0.46875,0.46875]}}}", "assets/minecraft/models/required/player/head.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1,-2,17.5],\"scale\":[0.9375,0.9375,0.9375]}}}", "assets/minecraft/models/required/player/leg.json", "{\"parent\":\"item/player_head\",\"display\":{\"thirdperson_righthand\":{\"rotation\":[90,180,0],\"translation\":[-1,-2,10],\"scale\":[0.46875,0.703125,0.46875]}}}");
    }

    public String getSkullJson() {
        return "{\n   \"parent\": \"minecraft:item/template_skull\",\n   \"overrides\": [\n     { \"predicate\": { \"custom_model_data\": 1 }, \"model\": \"required/player/head\" },\n     { \"predicate\": { \"custom_model_data\": 2 }, \"model\": \"required/player/norm/right_shoulder\" },\n     { \"predicate\": { \"custom_model_data\": 3 }, \"model\": \"required/player/norm/left_shoulder\" },\n     { \"predicate\": { \"custom_model_data\": 4 }, \"model\": \"required/player/norm/arm\" },\n     { \"predicate\": { \"custom_model_data\": 5 }, \"model\": \"required/player/slim/right_shoulder\" },\n     { \"predicate\": { \"custom_model_data\": 6 }, \"model\": \"required/player/slim/left_shoulder\" },\n     { \"predicate\": { \"custom_model_data\": 7 }, \"model\": \"required/player/slim/arm\" },\n     { \"predicate\": { \"custom_model_data\": 8 }, \"model\": \"required/player/body\" },\n     { \"predicate\": { \"custom_model_data\": 9 }, \"model\": \"required/player/leg\" }\n   ]\n }";
    }

    public String getShaderFsh() {
        return "#version 150\n\n#moj_import <fog.glsl>\n\nuniform sampler2D Sampler0;\n\nuniform vec4 ColorModulator;\nuniform float FogStart;\nuniform float FogEnd;\nuniform vec4 FogColor;\n\nin float vertexDistance;\nin vec4 vertexColor;\nin vec4 lightMapColor;\nin vec4 overlayColor;\nin vec2 texCoord0;\nin vec2 texCoord1;\nin vec4 normal;\n\nin vec3 a, b;\n\nout vec4 fragColor;\n\nvec2 getSize() {\n    vec2 uv1 = a.xy / a.z;\n    vec2 uv2 = b.xy / b.z;\n    return round((max(uv1, uv2) - min(uv1, uv2)) * 64);\n}\n\nvoid main() {\n\n    if(texCoord0.x < 0) {\n        discard;\n    }\n\n    vec2 uv = texCoord0;\n    if(getSize() != vec2(8, 8))\n        uv = texCoord1;\n\n    vec4 color = texture(Sampler0, uv);\n    if (color.a < 0.1) {\n        discard;\n    }\n    color *= vertexColor * ColorModulator;\n    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);\n    color *= lightMapColor;\n    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);\n}\n";
    }

    public String getShaderVsh() {
        return "#version 150\n\n#moj_import <light.glsl>\n#moj_import <fog.glsl>\n\nin vec3 Position, Normal;\nin vec4 Color;\nin vec2 UV0;\nin ivec2 UV1, UV2;\n\nuniform sampler2D Sampler0, Sampler1, Sampler2;\n\nuniform mat4 ModelViewMat, ProjMat;\nuniform int FogShape;\n\nuniform vec3 Light0_Direction, Light1_Direction;\n\nout float vertexDistance;\nout vec4 vertexColor, lightMapColor, overlayColor, normal;\nout vec2 texCoord0, texCoord1;\nout vec3 a, b;\n\nvec3 getCubeSize(int cube) {\n    if(cube >= 2 && cube <= 7)\n        return vec3(8, 4, 4);\n\n    if(cube >= 8 && cube <= 15)\n        return vec3(3, 6, 4);\n\n    if(cube >= 16 && cube <= 23)\n        return vec3(4, 6, 4);\n\n    return vec3(8, 8, 8);\n}\n\nvec2 getBoxUV(int cube) {\n    switch(cube) {\n        case 0: // Head\n            return vec2(0, 0);\n        case 1: // Hat\n            return vec2(32, 0);\n        case 2: // Hip\n        case 4: // Waist\n        case 6: // Chest\n            return vec2(16, 16);\n        case 3:\n        case 5:\n        case 7: // Jacket\n            return vec2(16, 32);\n        case 8:\n        case 10: // Right Arm\n            return vec2(40, 16);\n        case 9:\n        case 11: // Right Sleeve\n            return vec2(40, 32);\n        case 12:\n        case 14: // Left Arm\n            return vec2(32, 48);\n        case 13:\n        case 15: // Left Sleeve\n            return vec2(48, 48);\n        case 16:\n        case 18: // Right Leg\n            return vec2(0, 16);\n        case 17:\n        case 19: // Right Pant\n            return vec2(0, 32);\n        case 20:\n        case 22: // Left Leg\n            return vec2(16, 48);\n        case 21:\n        case 23: // Left Pant\n            return vec2(0, 48);\n\n    }\n    return vec2(0, 0);\n}\n\nfloat getYOffset(int cube) {\n    float r = 0;\n    switch(cube) {\n        case 2:\n        case 3:\n            r = 8;\n            break;\n        case 4:\n        case 5:\n            r = 4;\n            break;\n        case 10: // Right Arm\n        case 11: // Right Sleeve\n        case 14: // Left Arm\n        case 15: // Left Sleeve\n        case 18: // Right Leg\n        case 19: // Right Pant\n        case 22: // Left Leg\n        case 23: // Left Pant\n            r = 6;\n            break;\n    }\n    return r / 64.;\n}\n\nvec2 getUVOffset(int corner, vec3 cubeSize, float yOffset) {\n    vec2 offset, uv;\n    switch(corner / 4) {\n        case 0: // Up\n            offset = vec2(cubeSize.z, 0);\n            uv = vec2(cubeSize.x, cubeSize.z);\n            break;\n        case 1: // Down\n            offset = vec2(cubeSize.z + cubeSize.x, 0);\n            uv = vec2(cubeSize.x, cubeSize.z);\n            break;\n        case 2: // Right\n            offset = vec2(0, cubeSize.z);\n            offset.y += yOffset;\n            uv = vec2(cubeSize.z, cubeSize.y);\n            break;\n        case 3: // Front\n            offset = vec2(cubeSize.z, cubeSize.z);\n            offset.y += yOffset;\n            uv = vec2(cubeSize.x, cubeSize.y);\n            break;\n        case 4: // Left\n            offset = vec2(cubeSize.z + cubeSize.x, cubeSize.z);\n            offset.y += yOffset;\n            uv = vec2(cubeSize.z, cubeSize.y);\n            break;\n        case 5: // Back\n            offset = vec2(2 * cubeSize.z + cubeSize.x, cubeSize.z);\n            offset.y += yOffset;\n            uv = vec2(cubeSize.x, cubeSize.y);\n            break;\n    }\n\n    switch(corner % 4) {\n        case 0:\n            offset += vec2(uv.x, 0);\n            break;\n        case 2:\n            offset += vec2(0, uv.y);\n            break;\n        case 3:\n            offset += vec2(uv.x, uv.y);\n            break;\n    }\n\n    return offset;\n}\n\nbool shouldRender(int cube, int corner) {\n    if(corner / 8 != 1 || cube % 2 == 0 || cube == 1)\n        return true;\n\n    if(cube == 5)\n        return false;\n\n    bool r = false;\n    switch(cube) {\n        case 7:\n        case 9:\n        case 13:\n        case 17:\n        case 21:\n            r = true;\n    }\n\n    if(corner / 4 == 3)\n        r = !r;\n\n    return r;\n}\n\nvoid main() {\n    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n\n    a = b = vec3(0);\n    if(textureSize(Sampler0, 0) == vec2(64, 64) && UV0.y <= 0.25 && (gl_VertexID / 24 != 6 || UV0.x <= 0.5)) {\n\n        switch(gl_VertexID % 4) {\n            case 0: a = vec3(UV0, 1); break;\n            case 2: b = vec3(UV0, 1); break;\n        }\n\t\t// 1 3 5 9 11 13 15 17\n        int cube = (gl_VertexID / 24) % 24;\n        int corner = gl_VertexID % 24;\n        if(shouldRender(cube, corner)) {\n            vec3 cubeSize = getCubeSize(cube) / 64;\n            vec2 boxUV = getBoxUV(cube) / 64;\n            vec2 uvOffset = getUVOffset(corner, cubeSize, getYOffset(cube));\n            texCoord0 = boxUV + uvOffset;\n        }else {\n            texCoord0 = vec2(-1);\n        }\n    }else {\n        texCoord0 = UV0;\n    }\n\n    // vertexDistance = fog_distance(ModelViewMat, IViewRotMat * Position, FogShape);\n    vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);\n    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);\n    lightMapColor = texelFetch(Sampler2, UV2 / 16, 0);\n    overlayColor = texelFetch(Sampler1, UV1, 0);\n    texCoord1 = UV0;\n    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);\n}\n\n\n";
    }

    public String getShaderJson() {
        return "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"rendertype_entity_translucent\",\n    \"fragment\": \"rendertype_entity_translucent\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV1\",\n        \"UV2\",\n        \"Normal\"\n    ],\n    \"samplers\": [\n        { \"name\": \"Sampler0\" },\n        { \"name\": \"Sampler1\" },\n        { \"name\": \"Sampler2\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n        { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] },\n        { \"name\": \"FogShape\", \"type\": \"int\", \"count\": 1, \"values\": [ 0 ] }\n    ]\n}\n\n";
    }
}

