/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.gestures;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.gestures.GestureManager;
import io.th0rgal.oraxen.gestures.QuitMethod;
import io.th0rgal.oraxen.utils.VersionUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class GestureListener
implements Listener {
    private final GestureManager gestureManager;

    public GestureListener(GestureManager gestureManager) {
        this.gestureManager = gestureManager;
        if (VersionUtil.isPaperServer()) {
            Bukkit.getPluginManager().registerEvents((Listener)new GesturePaperListener(), (Plugin)OraxenPlugin.get());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.quit(event.getPlayer(), null);
    }

    @EventHandler
    public void onToggleSneak(PlayerToggleSneakEvent event) {
        this.quit(event.getPlayer(), QuitMethod.SNEAK);
    }

    private void quit(Player player, QuitMethod quitMethod) {
        if (!this.gestureManager.isPlayerGesturing(player)) {
            return;
        }
        this.gestureManager.getPlayerModel(player).stopAnimation(quitMethod);
    }

    public class GesturePaperListener
    implements Listener {
        @EventHandler
        public void onJump(PlayerJumpEvent event) {
            GestureListener.this.quit(event.getPlayer(), QuitMethod.JUMP);
        }
    }
}

