/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.font;

import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.placeholderapi.PapiAliases;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.FontManager;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.font.GlyphTag;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.Arrays;
import java.util.Map;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class FontEvents
implements Listener {
    private final FontManager manager;

    public FontEvents(FontManager manager) {
        this.manager = manager;
        if (VersionUtil.isPaperServer() && !Settings.SPIGOT_CHAT_FORMATTING.toBool().booleanValue()) {
            if (VersionUtil.atOrAbove("1.19.1")) {
                Bukkit.getPluginManager().registerEvents((Listener)new PaperChatHandler(), (Plugin)OraxenPlugin.get());
            }
            Bukkit.getPluginManager().registerEvents((Listener)new LegacyPaperChatHandler(), (Plugin)OraxenPlugin.get());
        } else {
            Bukkit.getPluginManager().registerEvents((Listener)new SpigotChatHandler(), (Plugin)OraxenPlugin.get());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBookGlyph(PlayerEditBookEvent event) {
        if (!Settings.FORMAT_BOOKS.toBool().booleanValue() || this.manager.useNmsGlyphs()) {
            return;
        }
        BookMeta meta = event.getNewBookMeta();
        for (String page : meta.getPages()) {
            int i = meta.getPages().indexOf(page) + 1;
            if (i == 0) continue;
            for (Character character : this.manager.getReverseMap().keySet()) {
                Glyph glyph;
                if (!page.contains(String.valueOf(character)) || (glyph = this.manager.getGlyphFromName(this.manager.getReverseMap().get(character))).hasPermission(event.getPlayer())) continue;
                Message.NO_PERMISSION.send((CommandSender)event.getPlayer(), AdventureUtils.tagResolver("permission", glyph.getPermission()));
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBookGlyph(PlayerInteractEvent event) {
        Object object;
        Player player = event.getPlayer();
        if (!Settings.FORMAT_BOOKS.toBool().booleanValue()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() == null || !((object = event.getItem().getItemMeta()) instanceof BookMeta)) {
            return;
        }
        BookMeta meta = (BookMeta)object;
        if (event.getItem().getType() != Material.WRITTEN_BOOK) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.ALLOW) {
            return;
        }
        for (String page : meta.getPages()) {
            int i = meta.getPages().indexOf(page) + 1;
            if (i == 0) continue;
            for (Map.Entry<String, Glyph> entry : this.manager.getGlyphByPlaceholderMap().entrySet()) {
                String unicode = String.valueOf(entry.getValue().getCharacter());
                if (entry.getValue().hasPermission(player)) {
                    page = this.manager.permsChatcolor == null ? page.replace(entry.getKey(), ChatColor.WHITE + unicode + ChatColor.BLACK).replace(unicode, ChatColor.WHITE + unicode + ChatColor.BLACK) : page.replace(entry.getKey(), ChatColor.WHITE + unicode + PapiAliases.setPlaceholders(player, this.manager.permsChatcolor)).replace(unicode, ChatColor.WHITE + unicode + ChatColor.BLACK);
                }
                meta.setPage(i, AdventureUtils.parseLegacy(page));
            }
        }
        Book book = Book.builder().title(AdventureUtils.MINI_MESSAGE.deserialize((Object)(meta.getTitle() != null ? meta.getTitle() : ""))).author(AdventureUtils.MINI_MESSAGE.deserialize((Object)(meta.getAuthor() != null ? meta.getAuthor() : ""))).pages(meta.getPages().stream().map(p -> AdventureUtils.MINI_MESSAGE_EMPTY.deserialize(p, GlyphTag.getResolverForPlayer(player))).toList()).build();
        event.setUseItemInHand(Event.Result.DENY);
        OraxenPlugin.get().getAudience().player(player).openBook(book);
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignGlyph(SignChangeEvent event) {
        if (!Settings.FORMAT_SIGNS.toBool().booleanValue() || this.manager.useNmsGlyphs()) {
            return;
        }
        Player player = event.getPlayer();
        for (String line : event.getLines()) {
            line = AdventureUtils.parseLegacyThroughMiniMessage(line);
            int i = Arrays.stream(event.getLines()).toList().indexOf(line);
            if (i == -1) continue;
            for (Character c : this.manager.getReverseMap().keySet()) {
                Glyph glyph;
                if (!line.contains(String.valueOf(c)) || (glyph = this.manager.getGlyphFromName(this.manager.getReverseMap().get(c))).hasPermission(player)) continue;
                Message.NO_PERMISSION.send((CommandSender)player, AdventureUtils.tagResolver("permission", glyph.getPermission()));
                event.setCancelled(true);
            }
            for (Map.Entry entry : this.manager.getGlyphByPlaceholderMap().entrySet()) {
                String unicode = String.valueOf(((Glyph)entry.getValue()).getCharacter());
                if (!((Glyph)entry.getValue()).hasPermission(player)) continue;
                line = this.manager.permsChatcolor == null ? line.replace((CharSequence)entry.getKey(), ChatColor.WHITE + unicode + ChatColor.BLACK).replace(unicode, ChatColor.WHITE + unicode + ChatColor.BLACK) : line.replace((CharSequence)entry.getKey(), ChatColor.WHITE + unicode + PapiAliases.setPlaceholders(player, this.manager.permsChatcolor)).replace(unicode, ChatColor.WHITE + unicode + ChatColor.BLACK);
            }
            event.setLine(i, AdventureUtils.parseLegacy(line));
        }
    }

    @EventHandler
    public void onPlayerRename(InventoryClickEvent event) {
        Inventory inventory = event.getClickedInventory();
        if (!(inventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory clickedInv = (AnvilInventory)inventory;
        if (!Settings.FORMAT_ANVIL.toBool().booleanValue() || this.manager.useNmsGlyphs() || event.getSlot() != 2) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String displayName = clickedInv.getRenameText();
        ItemStack inputItem = clickedInv.getItem(0);
        ItemStack resultItem = clickedInv.getItem(2);
        if (resultItem == null || !OraxenItems.exists(inputItem)) {
            return;
        }
        if (displayName != null) {
            displayName = AdventureUtils.parseLegacyThroughMiniMessage(displayName);
            for (Character c : this.manager.getReverseMap().keySet()) {
                Glyph glyph;
                if (!displayName.contains(String.valueOf(c)) || (glyph = this.manager.getGlyphFromName(this.manager.getReverseMap().get(c))).hasPermission(player)) continue;
                Glyph required = this.manager.getGlyphFromName("required");
                String replacement = required.hasPermission(player) ? String.valueOf(required.getCharacter()) : "";
                Message.NO_PERMISSION.send((CommandSender)player, AdventureUtils.tagResolver("permission", glyph.getPermission()));
                displayName = displayName.replace(String.valueOf(c), replacement);
            }
            for (Map.Entry entry : this.manager.getGlyphByPlaceholderMap().entrySet()) {
                if (!((Glyph)entry.getValue()).hasPermission(player)) continue;
                displayName = this.manager.permsChatcolor == null ? displayName.replace((CharSequence)entry.getKey(), String.valueOf(((Glyph)entry.getValue()).getCharacter())) : displayName.replace((CharSequence)entry.getKey(), ChatColor.WHITE + String.valueOf(((Glyph)entry.getValue()).getCharacter()) + PapiAliases.setPlaceholders(player, this.manager.permsChatcolor));
            }
        }
        String strippedDownInputDisplay = AdventureUtils.MINI_MESSAGE.stripTags(AdventureUtils.parseLegacy(inputItem.getItemMeta().getDisplayName()));
        if ((displayName == null || displayName.isEmpty()) && OraxenItems.exists(inputItem) || strippedDownInputDisplay.equals(displayName)) {
            displayName = (String)inputItem.getItemMeta().getPersistentDataContainer().get(ItemBuilder.ORIGINAL_NAME_KEY, PersistentDataType.STRING);
        }
        String string = displayName;
        ItemUtils.editItemMeta(resultItem, meta -> meta.setDisplayName(finalDisplayName));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.manager.sendGlyphTabCompletion(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.manager.clearGlyphTabCompletions(event.getPlayer());
    }

    private Component format(Component message, Player player) {
        Key randomKey = Key.key((String)"random");
        String serialized = (String)AdventureUtils.MINI_MESSAGE.serialize(message);
        for (Character c : this.manager.getReverseMap().keySet()) {
            Glyph glyph;
            if (!serialized.contains(c.toString()) || (glyph = this.manager.getGlyphFromName(this.manager.getReverseMap().get(c))).hasPermission(player)) continue;
            message.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(c.toString()).replacement((ComponentLike)glyph.getGlyphComponent().font(randomKey)).build());
        }
        for (Map.Entry entry : this.manager.getGlyphByPlaceholderMap().entrySet()) {
            if (!((Glyph)entry.getValue()).hasPermission(player)) continue;
            message = message.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral((String)entry.getKey()).replacement((ComponentLike)((Glyph)entry.getValue()).getGlyphComponent()).build());
        }
        return message;
    }

    public class PaperChatHandler
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void onPlayerChat(AsyncChatDecorateEvent event) {
            if (!Settings.FORMAT_CHAT.toBool().booleanValue() || FontEvents.this.manager.useNmsGlyphs()) {
                return;
            }
            event.result(FontEvents.this.format(event.result(), event.player()));
        }
    }

    public class LegacyPaperChatHandler
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onPlayerChat(AsyncChatEvent event) {
            if (!Settings.FORMAT_CHAT.toBool().booleanValue() || FontEvents.this.manager.useNmsGlyphs()) {
                return;
            }
            Component message = VersionUtil.atOrAbove("1.19.1") ? event.message() : FontEvents.this.format(event.message(), event.getPlayer());
            Object object = message = message != null ? message : Component.empty();
            if (!message.equals(Component.empty())) {
                return;
            }
            event.viewers().clear();
            event.setCancelled(true);
        }
    }

    public class SpigotChatHandler
    implements Listener {
        @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            if (!Settings.FORMAT_CHAT.toBool().booleanValue() || FontEvents.this.manager.useNmsGlyphs()) {
                return;
            }
            String format = this.format(event.getFormat(), null);
            String message = this.format(event.getMessage(), event.getPlayer());
            if (format == null || message == null) {
                event.setCancelled(true);
            } else {
                event.setFormat(format);
                event.setMessage(message);
            }
        }

        private String format(String string, @Nullable Player player) {
            string = AdventureUtils.parseLegacyThroughMiniMessage(string, player);
            if (player != null) {
                for (Character c : FontEvents.this.manager.getReverseMap().keySet()) {
                    Glyph glyph;
                    if (!string.contains(String.valueOf(c)) || (glyph = FontEvents.this.manager.getGlyphFromName(FontEvents.this.manager.getReverseMap().get(c))).hasPermission(player)) continue;
                    Message.NO_PERMISSION.send((CommandSender)player, AdventureUtils.tagResolver("permission", glyph.getPermission()));
                    return null;
                }
            }
            for (Map.Entry entry : FontEvents.this.manager.getGlyphByPlaceholderMap().entrySet()) {
                String unicode = ChatColor.WHITE + String.valueOf(((Glyph)entry.getValue()).getCharacter());
                if (player != null && !((Glyph)entry.getValue()).hasPermission(player)) continue;
                string = FontEvents.this.manager.permsChatcolor == null ? string.replace((CharSequence)entry.getKey(), unicode) : string.replace((CharSequence)entry.getKey(), unicode + PapiAliases.setPlaceholders(player, FontEvents.this.manager.permsChatcolor));
            }
            return string;
        }
    }
}

