/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.compatibilities.provided.lightapi;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockBreakEvent;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockBreakEvent;
import io.th0rgal.oraxen.compatibilities.provided.lightapi.LightApiUtils;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WrappedLightAPI {
    public static boolean lightApiEnabled = Bukkit.getPluginManager().isPluginEnabled("LightAPI");
    public static boolean lighterApiEnabled = Bukkit.getPluginManager().isPluginEnabled("LighterAPI");
    private static boolean loaded;

    private WrappedLightAPI() {
    }

    public static void init() {
        if (lightApiEnabled) {
            loaded = true;
        } else if (lighterApiEnabled) {
            loaded = true;
        }
        if (loaded) {
            Bukkit.getPluginManager().registerEvents((Listener)new LightApiListener(), (Plugin)OraxenPlugin.get());
        }
    }

    public static void createBlockLight(Location location, int value) {
        if (loaded) {
            LightApiUtils.createBlockLight(location, value);
        }
    }

    public static void removeBlockLight(Location location) {
        if (loaded) {
            LightApiUtils.removeBlockLight(location);
        }
    }

    public static class LightApiListener
    implements Listener {
        private final Set<BlockFace> blockFaces = Set.of(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST);

        @EventHandler
        public void onBlockBreak(OraxenNoteBlockBreakEvent event) {
            this.updateLight(event.getBlock());
        }

        @EventHandler
        public void onBlockBreak(OraxenStringBlockBreakEvent event) {
            this.updateLight(event.getBlock());
        }

        public void updateLight(Block block) {
            this.removeSurroundingLight(block);
            for (BlockFace blockFace : this.blockFaces) {
                Block relative = block.getRelative(blockFace);
                if (!relative.equals(block)) {
                    this.updateLight(relative);
                }
                for (BlockFace blockFace2 : this.blockFaces) {
                    relative = block.getRelative(blockFace).getRelative(blockFace2);
                    if (relative.equals(block)) continue;
                    this.updateLight(relative);
                }
            }
        }

        private void removeSurroundingLight(Block block) {
            for (BlockFace blockFace : this.blockFaces) {
                WrappedLightAPI.removeBlockLight(block.getRelative(blockFace).getLocation());
            }
        }

        private void fixLight(Block block) {
            NoteBlockMechanic noteMechanic = OraxenBlocks.getNoteBlockMechanic(block);
            StringBlockMechanic stringMechanic = OraxenBlocks.getStringMechanic(block);
            if (noteMechanic != null && noteMechanic.hasLight()) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> WrappedLightAPI.createBlockLight(block.getLocation(), noteMechanic.getLight()), 1L);
            } else if (stringMechanic != null && stringMechanic.hasLight()) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> WrappedLightAPI.createBlockLight(block.getLocation(), stringMechanic.getLight()), 1L);
            }
        }
    }
}

