/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.compatibilities.provided.blocklocker;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.compatibilities.CompatibilityProvider;
import io.th0rgal.oraxen.compatibilities.provided.blocklocker.BlockLockerMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import nl.rutgerkok.blocklocker.ProtectableBlocksSettings;
import nl.rutgerkok.blocklocker.ProtectionType;
import nl.rutgerkok.blocklocker.impl.BlockLockerPluginImpl;
import org.bukkit.block.Block;

public class BlockLockerCompatibility
extends CompatibilityProvider<BlockLockerPluginImpl> {
    public BlockLockerCompatibility() {
        BlockLockerAPIv2.getPlugin().getChestSettings().getExtraProtectables().add(new ProtectableBlocksSettings(){

            public boolean canProtect(Block block) {
                FurnitureMechanic furnitureMechanic;
                StringBlockMechanic stringMechanic;
                BlockLockerMechanic blockLocker = null;
                NoteBlockMechanic noteMechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (noteMechanic != null) {
                    blockLocker = noteMechanic.getBlockLocker();
                }
                if ((stringMechanic = OraxenBlocks.getStringMechanic(block)) != null) {
                    blockLocker = stringMechanic.getBlockLocker();
                }
                if ((furnitureMechanic = OraxenFurniture.getFurnitureMechanic(block)) != null) {
                    blockLocker = furnitureMechanic.getBlockLocker();
                }
                return blockLocker != null && blockLocker.canProtect();
            }

            public boolean canProtect(ProtectionType type, Block block) {
                FurnitureMechanic furnitureMechanic;
                StringBlockMechanic stringMechanic;
                BlockLockerMechanic blockLocker = null;
                NoteBlockMechanic noteMechanic = OraxenBlocks.getNoteBlockMechanic(block);
                if (noteMechanic != null) {
                    blockLocker = noteMechanic.getBlockLocker();
                }
                if ((stringMechanic = OraxenBlocks.getStringMechanic(block)) != null) {
                    blockLocker = stringMechanic.getBlockLocker();
                }
                if ((furnitureMechanic = OraxenFurniture.getFurnitureMechanic(block)) != null) {
                    blockLocker = furnitureMechanic.getBlockLocker();
                }
                return blockLocker != null && blockLocker.canProtect() && blockLocker.getProtectionType() == type;
            }
        });
    }
}

