/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.compatibilities;

import io.th0rgal.oraxen.compatibilities.CompatibilityListener;
import io.th0rgal.oraxen.compatibilities.CompatibilityProvider;
import io.th0rgal.oraxen.compatibilities.provided.blocklocker.BlockLockerCompatibility;
import io.th0rgal.oraxen.compatibilities.provided.bossshoppro.BossShopProCompatibility;
import io.th0rgal.oraxen.compatibilities.provided.lightapi.WrappedLightAPI;
import io.th0rgal.oraxen.compatibilities.provided.mythicmobs.MythicMobsCompatibility;
import io.th0rgal.oraxen.compatibilities.provided.placeholderapi.PlaceholderAPICompatibility;
import io.th0rgal.oraxen.compatibilities.provided.worldedit.WrappedWorldEdit;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;

public class CompatibilitiesManager {
    private static final ConcurrentHashMap<String, Class<? extends CompatibilityProvider<?>>> COMPATIBILITY_PROVIDERS = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CompatibilityProvider<?>> ACTIVE_COMPATIBILITY_PROVIDERS = new ConcurrentHashMap();

    private CompatibilitiesManager() {
    }

    public static void enableNativeCompatibilities() {
        WrappedLightAPI.init();
        WrappedWorldEdit.init();
        WrappedWorldEdit.registerParser();
        new CompatibilityListener();
        CompatibilitiesManager.addCompatibility("PlaceholderAPI", PlaceholderAPICompatibility.class, true);
        CompatibilitiesManager.addCompatibility("BossShopPro", BossShopProCompatibility.class, true);
        CompatibilitiesManager.addCompatibility("MythicMobs", MythicMobsCompatibility.class, true);
        CompatibilitiesManager.addCompatibility("BlockLocker", BlockLockerCompatibility.class, true);
    }

    public static void disableCompatibilities() {
        WrappedWorldEdit.unregister();
        ACTIVE_COMPATIBILITY_PROVIDERS.forEach((pluginName, compatibilityProvider) -> CompatibilitiesManager.disableCompatibility(pluginName));
    }

    public static boolean enableCompatibility(String pluginName) {
        try {
            if (!ACTIVE_COMPATIBILITY_PROVIDERS.containsKey(pluginName) && COMPATIBILITY_PROVIDERS.containsKey(pluginName) && CompatibilitiesManager.hasPlugin(pluginName)) {
                CompatibilityProvider<?> compatibilityProvider = COMPATIBILITY_PROVIDERS.get(pluginName).getConstructor(new Class[0]).newInstance(new Object[0]);
                compatibilityProvider.enable(pluginName);
                ACTIVE_COMPATIBILITY_PROVIDERS.put(pluginName, compatibilityProvider);
                Message.PLUGIN_HOOKS.log(AdventureUtils.tagResolver("plugin", pluginName));
                return true;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean disableCompatibility(String pluginName) {
        try {
            if (!ACTIVE_COMPATIBILITY_PROVIDERS.containsKey(pluginName)) {
                return false;
            }
            if (ACTIVE_COMPATIBILITY_PROVIDERS.get(pluginName).isEnabled()) {
                ACTIVE_COMPATIBILITY_PROVIDERS.get(pluginName).disable();
            }
            ACTIVE_COMPATIBILITY_PROVIDERS.remove(pluginName);
            Message.PLUGIN_UNHOOKS.log(AdventureUtils.tagResolver("plugin", pluginName));
            return true;
        }
        catch (Exception e) {
            Logs.logWarning(e.getMessage());
            return false;
        }
    }

    public static boolean addCompatibility(String compatibilityPluginName, Class<? extends CompatibilityProvider<?>> clazz, boolean tryEnable) {
        try {
            if (compatibilityPluginName != null && clazz != null) {
                COMPATIBILITY_PROVIDERS.put(compatibilityPluginName, clazz);
                return !tryEnable || CompatibilitiesManager.enableCompatibility(compatibilityPluginName);
            }
        }
        catch (Exception e) {
            Logs.logWarning(e.getMessage());
            return false;
        }
        return false;
    }

    public static boolean addCompatibility(String compatibilityPluginName, Class<? extends CompatibilityProvider<?>> clazz) {
        return CompatibilitiesManager.addCompatibility(compatibilityPluginName, clazz, false);
    }

    public static CompatibilityProvider<?> getActiveCompatibility(String pluginName) {
        return ACTIVE_COMPATIBILITY_PROVIDERS.get(pluginName);
    }

    public static Class<? extends CompatibilityProvider<?>> getCompatibility(String pluginName) {
        return COMPATIBILITY_PROVIDERS.get(pluginName);
    }

    public static boolean isCompatibilityEnabled(String pluginName) {
        return ACTIVE_COMPATIBILITY_PROVIDERS.containsKey(pluginName) && ACTIVE_COMPATIBILITY_PROVIDERS.get(pluginName).isEnabled();
    }

    public static ConcurrentHashMap<String, Class<? extends CompatibilityProvider<?>>> getCompatibilityProviders() {
        return COMPATIBILITY_PROVIDERS;
    }

    public static ConcurrentHashMap<String, CompatibilityProvider<?>> getActiveCompatibilityProviders() {
        return ACTIVE_COMPATIBILITY_PROVIDERS;
    }

    public static boolean hasPlugin(String name) {
        return Bukkit.getPluginManager().isPluginEnabled(name);
    }
}

