/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import com.jeff_media.customblockdata.CustomBlockData;
import com.jeff_media.morepersistentdatatypes.DataType;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.BlockLocation;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.BlockHelpers;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpdateCommand {
    CommandAPICommand getUpdateCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("update").withPermission("oraxen.command.update")).withSubcommands((AbstractCommandAPICommand[])new CommandAPICommand[]{this.getFurnitureUpdateCommand(), this.getItemUpdateCommand()});
    }

    private CommandAPICommand getItemUpdateCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("item").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("targets")})).executesPlayer((player, args) -> {
            List<Player> targets = ((Collection)args.get("targets")).stream().filter(entity -> entity instanceof Player).map(e -> (Player)e).toList();
            for (Player p : targets) {
                int updated = 0;
                for (int i = 0; i < p.getInventory().getSize(); ++i) {
                    ItemStack oldItem = p.getInventory().getItem(i);
                    ItemStack newItem = ItemUpdater.updateItem(oldItem);
                    if (oldItem == null || oldItem.equals((Object)newItem)) continue;
                    p.getInventory().setItem(i, newItem);
                    ++updated;
                }
                p.updateInventory();
                Message.UPDATED_ITEMS.send((CommandSender)player, AdventureUtils.tagResolver("amount", String.valueOf(updated)), AdventureUtils.tagResolver("player", p.getDisplayName()));
            }
        });
    }

    private CommandAPICommand getFurnitureUpdateCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("furniture").withOptionalArguments((AbstractArgument[])new Argument[]{new IntegerArgument("radius")})).executesPlayer((player, args) -> {
            int radius = args.getOptional("radius").orElse(10);
            List<Entity> targets = ((Collection)args.getOptional("targets").orElse(player.getNearbyEntities((double)radius, (double)radius, (double)radius))).stream().filter(OraxenFurniture::isBaseEntity).toList();
            for (Entity entity : targets) {
                OraxenFurniture.updateFurniture(entity);
            }
            this.updateBrokenFurnitureBlocks(player, radius);
        });
    }

    private void updateBrokenFurnitureBlocks(Player player, int radius) {
        if (!Settings.EXPERIMENTAL_FIX_BROKEN_FURNITURE.toBool().booleanValue()) {
            return;
        }
        Set<Chunk> chunks = UpdateCommand.getChunksAroundPlayer(player, radius);
        HashSet blocks = new HashSet();
        for (Chunk chunk : chunks) {
            blocks.addAll(CustomBlockData.getBlocksWithCustomData((Plugin)OraxenPlugin.get(), (Chunk)chunk));
        }
        for (Block block : blocks.stream().filter(b -> b.getLocation().distance(player.getLocation()) <= (double)radius).toList()) {
            FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
            if (mechanic == null) {
                return;
            }
            Entity baseEntity = mechanic.getBaseEntity(block);
            if (baseEntity != null) {
                return;
            }
            Location rootLoc = new BlockLocation((String)BlockHelpers.getPDC(block).getOrDefault(FurnitureMechanic.ROOT_KEY, DataType.STRING, (Object)"")).toLocation(block.getWorld());
            float yaw = ((Float)BlockHelpers.getPDC(block).getOrDefault(FurnitureMechanic.ORIENTATION_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
            if (rootLoc == null) {
                return;
            }
            mechanic.getLocations(yaw, rootLoc, mechanic.getBarriers()).forEach(loc -> {
                loc.getBlock().setType(Material.AIR);
                new CustomBlockData(loc.getBlock(), (Plugin)OraxenPlugin.get()).clear();
            });
            mechanic.place(rootLoc, yaw, BlockFace.UP);
        }
    }

    private static Set<Chunk> getChunksAroundPlayer(Player player, int radius) {
        Location loc = player.getLocation();
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (int x = loc.getBlockX() - radius; x <= loc.getBlockX() + radius; ++x) {
            for (int z = loc.getBlockZ() - radius; z <= loc.getBlockZ() + radius; ++z) {
                chunks.add(new Location(player.getWorld(), (double)x, (double)loc.getBlockY(), (double)z).getChunk());
            }
        }
        return chunks;
    }
}

