/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.OraxenPack;
import io.th0rgal.oraxen.api.events.OraxenItemsLoadedEvent;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.hud.HudManager;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.recipes.RecipesManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ReloadCommand {
    public static void reloadItems(@Nullable CommandSender sender) {
        Message.RELOAD.send(sender, AdventureUtils.tagResolver("reloaded", "items"));
        OraxenItems.loadItems();
        OraxenPlugin.get().getInvManager().regen();
        Bukkit.getPluginManager().callEvent((Event)new OraxenItemsLoadedEvent());
        if (Settings.UPDATE_ITEMS.toBool().booleanValue() && Settings.UPDATE_ITEMS_ON_RELOAD.toBool().booleanValue()) {
            Logs.logInfo("Updating all items in player-inventories...");
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                PlayerInventory inventory = player.getInventory();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)OraxenPlugin.get(), () -> {
                    for (int i = 0; i < inventory.getSize(); ++i) {
                        ItemStack oldItem = inventory.getItem(i);
                        ItemStack newItem = ItemUpdater.updateItem(oldItem);
                        if (oldItem == null || oldItem.equals((Object)newItem)) continue;
                        inventory.setItem(i, newItem);
                    }
                });
            }
        }
        if (Settings.UPDATE_FURNITURE.toBool().booleanValue() && Settings.UPDATE_FURNITURE_ON_RELOAD.toBool().booleanValue()) {
            Logs.logInfo("Updating all placed furniture...");
            for (World world : Bukkit.getServer().getWorlds()) {
                world.getEntities().stream().filter(OraxenFurniture::isBaseEntity).forEach(OraxenFurniture::updateFurniture);
            }
        }
    }

    public static void reloadPack(@Nullable CommandSender sender) {
        Message.PACK_REGENERATED.send(sender, new TagResolver[0]);
        OraxenPack.reloadPack();
    }

    public static void reloadHud(@Nullable CommandSender sender) {
        Message.RELOAD.send(sender, AdventureUtils.tagResolver("reloaded", "hud"));
        OraxenPlugin.get().reloadConfigs();
        HudManager hudManager = new HudManager(OraxenPlugin.get().getConfigsManager());
        OraxenPlugin.get().setHudManager(hudManager);
        hudManager.loadHuds(hudManager.getHudConfigSection());
        hudManager.parsedHudDisplays = hudManager.generateHudDisplays();
        hudManager.reregisterEvents();
        hudManager.restartTask();
    }

    public static void reloadGestures(@Nullable CommandSender sender) {
        Message.RELOAD.send(sender, AdventureUtils.tagResolver("reloaded", "gestures"));
        OraxenPlugin.get().getGesturesManager().reload();
    }

    public static void reloadRecipes(@Nullable CommandSender sender) {
        Message.RELOAD.send(sender, AdventureUtils.tagResolver("reloaded", "recipes"));
        RecipesManager.reload();
    }

    CommandAPICommand getReloadCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reload").withAliases(new String[]{"rl"})).withPermission("oraxen.command.reload")).withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"items", "pack", "hud", "recipes", "messages", "all"}))})).executes((sender, args) -> {
            switch (((String)args.get("type")).toUpperCase()) {
                case "HUD": {
                    ReloadCommand.reloadHud(sender);
                    break;
                }
                case "ITEMS": {
                    ReloadCommand.reloadItems(sender);
                    break;
                }
                case "PACK": {
                    ReloadCommand.reloadPack(sender);
                    break;
                }
                case "RECIPES": {
                    ReloadCommand.reloadRecipes(sender);
                    break;
                }
                case "CONFIGS": {
                    OraxenPlugin.get().reloadConfigs();
                    break;
                }
                default: {
                    MechanicsManager.unloadListeners();
                    MechanicsManager.registerNativeMechanics();
                    OraxenPlugin.get().reloadConfigs();
                    ReloadCommand.reloadItems(sender);
                    ReloadCommand.reloadPack(sender);
                    ReloadCommand.reloadHud(sender);
                    ReloadCommand.reloadRecipes(sender);
                }
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                OraxenPlugin.get().getFontManager().sendGlyphTabCompletion(player);
            }
        }, new ExecutorType[0]);
    }
}

