/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.Map;
import net.kyori.adventure.audience.Audience;

public class ItemInfoCommand {
    CommandAPICommand getItemInfoCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("iteminfo").withPermission("oraxen.command.iteminfo")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("itemid").replaceSuggestions(ArgumentSuggestions.strings((String[])OraxenItems.getItemNames()))})).executes((commandSender, args) -> {
            String argument = (String)args.get("itemid");
            Audience audience = OraxenPlugin.get().getAudience().sender(commandSender);
            if (argument.equals("all")) {
                for (Map.Entry<String, ItemBuilder> entry : OraxenItems.getEntries()) {
                    this.sendItemInfo(audience, entry.getValue(), entry.getKey());
                }
            } else {
                ItemBuilder ib = OraxenItems.getItemById(argument);
                if (ib == null) {
                    audience.sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<red>No item found with ID</red> <dark_red>" + argument)));
                } else {
                    this.sendItemInfo(audience, ib, argument);
                }
            }
        }, new ExecutorType[0]);
    }

    private void sendItemInfo(Audience sender, ItemBuilder builder, String itemId) {
        sender.sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<dark_aqua>ItemID: <aqua>" + itemId)));
        sender.sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<dark_green>CustomModelData: <green>" + builder.getOraxenMeta().getCustomModelData())));
        sender.sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<dark_green>Material: <green>" + builder.getReferenceClone().getType())));
        sender.sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<dark_green>Model Name: <green>" + builder.getOraxenMeta().getModelName())));
        Logs.newline();
    }
}

