/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GlyphCommand {
    public CommandAPICommand getGlyphCommand() {
        List<Glyph> emojiList = OraxenPlugin.get().getFontManager().getEmojis().stream().toList();
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("emojis").withPermission("oraxen.command.emojis")).withPermission("oraxen.command.emoji")).executes((sender, args) -> {
            Player player = (Player)sender;
            boolean onlyShowPermissable = Settings.SHOW_PERMISSION_EMOJIS.toBool();
            List<Glyph> emojis = !onlyShowPermissable ? emojiList : emojiList.stream().filter(glyph -> glyph.hasPermission(player)).toList();
            TextComponent pages = Component.empty();
            if (emojis.isEmpty()) {
                Message.NO_EMOJIS.send((CommandSender)player, new TagResolver[0]);
                return;
            }
            block0: for (int p = 0; p < 50; ++p) {
                for (int i = 0; i < 256; ++i) {
                    int s = p * 256 + i + 1;
                    if (emojis.size() < s) break block0;
                    Glyph emoji = emojis.get(p * 256 + i);
                    Object[] placeholders = emoji.getPlaceholders();
                    Object finalString = "";
                    Object permissionMessage = "";
                    for (String string : placeholders) {
                        finalString = Arrays.toString(placeholders).replace("]", "").endsWith(string) ? (String)finalString + string : (String)finalString + string + "\n";
                        if (onlyShowPermissable) continue;
                        permissionMessage = (String)permissionMessage + (emoji.hasPermission(player) ? "\n" + ChatColor.GREEN + "Permitted" : "\n" + ChatColor.RED + "No Permission");
                    }
                    pages = pages.append(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<glyph:" + emoji.getName() + ">")).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)String.valueOf(emoji.getCharacter()))).hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)((String)finalString + (String)permissionMessage)))));
                }
            }
            Book book = Book.book((Component)Component.text((String)"Glyph Book"), (Component)Component.text((String)"Oraxen"), (Component[])new Component[]{pages});
            OraxenPlugin.get().getAudience().player(player).openBook(book);
        }, new ExecutorType[0]);
    }
}

