/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.gestures.GestureManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class GestureCommand {
    CommandAPICommand getGestureCommand() {
        GestureManager gestureManager = OraxenPlugin.get().getGesturesManager();
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("gesture").withAliases(new String[]{"gestures", "g"})).withPermission("oraxen.command.gesture")).withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("gesture").replaceSuggestions(ArgumentSuggestions.strings(GestureManager.getGestures())), (Argument)new PlayerArgument("player").setOptional(true)})).executes((sender, args) -> {
            if (!Settings.GESTURES_ENABLED.toBool().booleanValue() || VersionUtil.atOrAbove("1.20.3")) {
                OraxenPlugin.get().getAudience().sender(sender).sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)"<red>Gestures are not enabled!"));
                return;
            }
            String gesture = (String)args.get("gesture");
            if (!GestureManager.gestures.contains(gesture)) {
                Message.GESTURE_NO_GESTURE.send(sender, new TagResolver[0]);
                return;
            }
            if (args.count() == 1) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    gestureManager.playGesture(player, gesture);
                } else if (sender instanceof ConsoleCommandSender) {
                    ConsoleCommandSender console = (ConsoleCommandSender)sender;
                    Message.GESTURE_CONSOLE.send((CommandSender)console, new TagResolver[0]);
                }
            } else if (args.count() == 2) {
                Player secondPlayer = (Player)args.get("player");
                if (secondPlayer == null) {
                    secondPlayer = (Player)sender;
                }
                if (secondPlayer != null) {
                    if (sender.hasPermission("oraxen.command.gesture.others")) {
                        gestureManager.playGesture(secondPlayer, gesture);
                    } else {
                        Message.GESTURE_OTHERS_DENIED.send(sender, new TagResolver[0]);
                    }
                } else {
                    Message.NOT_PLAYER.send(sender, new TagResolver[0]);
                }
            }
        }, new ExecutorType[0]);
    }
}

