/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.JarReader;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;

public class VersionUtil {
    private static final Map<NMSVersion, Map<Integer, String>> versionMap = new HashMap<NMSVersion, Map<Integer, String>>();
    private static final String manifest;
    private static final boolean leaked;

    public static NMSVersion getNMSVersion(String version) {
        return versionMap.entrySet().stream().filter(e -> ((Map)e.getValue()).containsValue(version)).map(Map.Entry::getKey).findFirst().orElse(NMSVersion.UNKNOWN);
    }

    private static int getVersionValue(String version) {
        for (Map.Entry pair : versionMap.values().stream().flatMap(map -> map.entrySet().stream()).toList()) {
            if (!((String)pair.getValue()).equals(version)) continue;
            return (Integer)pair.getKey();
        }
        return -1;
    }

    public static boolean matchesServer(String server) {
        return server.equals(VersionUtil.getMinecraftVersion());
    }

    public static boolean isSupportedVersionOrNewer(String versionString) {
        int serverValue = VersionUtil.getVersionValue(VersionUtil.getMinecraftVersion());
        return VersionUtil.getVersionValue(versionString) <= serverValue;
    }

    public static boolean isPaperServer() {
        Server server = Bukkit.getServer();
        Validate.notNull((Object)server, (String)"Server cannot be null", (Object[])new Object[0]);
        if (server.getName().equalsIgnoreCase("Paper")) {
            return true;
        }
        try {
            Class.forName("com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isFoliaServer() {
        Server server = Bukkit.getServer();
        Validate.notNull((Object)server, (String)"Server cannot be null", (Object[])new Object[0]);
        return server.getName().equalsIgnoreCase("Folia");
    }

    public static boolean isSupportedVersion(@NotNull NMSVersion serverVersion, NMSVersion ... supportedVersions) {
        for (NMSVersion version : supportedVersions) {
            if (!version.equals((Object)serverVersion)) continue;
            return true;
        }
        Logs.logWarning(String.format("The Server version which you are running is unsupported, you are running version '%s'.", new Object[]{serverVersion}));
        Logs.logWarning(String.format("The plugin supports following versions %s.", VersionUtil.combineVersions(supportedVersions)));
        if (serverVersion == NMSVersion.UNKNOWN) {
            Logs.logWarning(String.format("The Version '%s' can indicate, that you are using a newer Minecraft version than currently supported.", new Object[]{serverVersion}));
            Logs.logWarning("In this case please update to the newest version of this plugin. If this is the newest Version, than please be patient. It can take a few weeks until the plugin is updated.");
        }
        Logs.logWarning("No compatible Server version found!");
        return false;
    }

    @NotNull
    private static String combineVersions(NMSVersion ... versions) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (NMSVersion version : versions) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append("'");
            stringBuilder.append((Object)version);
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    public static boolean isCompiled() {
        List<String> split = Arrays.stream(manifest.split(":|\n")).map(String::trim).toList();
        return Boolean.parseBoolean(split.get(split.indexOf("Compiled") + 1)) && !VersionUtil.isValidCompiler();
    }

    public static boolean isLeaked() {
        return leaked;
    }

    public static boolean isValidCompiler() {
        List<String> split = Arrays.stream(manifest.split(":|\n")).map(String::trim).toList();
        return Set.of("sivert", "thomas").contains(split.get(split.indexOf("Built-By") + 1).toLowerCase());
    }

    public static String getMinecraftVersion() {
        if (VersionUtil.isPaperServer()) {
            return Bukkit.getMinecraftVersion();
        }
        return Bukkit.getVersion().split("MC: ")[1].split("\\)")[0];
    }

    static {
        versionMap.put(NMSVersion.v1_20_R3, Map.of(11, "1.20.3", 12, "1.20.4"));
        versionMap.put(NMSVersion.v1_20_R2, Map.of(10, "1.20.2"));
        versionMap.put(NMSVersion.v1_20_R1, Map.of(8, "1.20", 9, "1.20.1"));
        versionMap.put(NMSVersion.v1_19_R3, Map.of(7, "1.19.4"));
        versionMap.put(NMSVersion.v1_19_R2, Map.of(6, "1.19.3"));
        versionMap.put(NMSVersion.v1_19_R1, Map.of(3, "1.19", 4, "1.19.1", 5, "1.19.2"));
        versionMap.put(NMSVersion.v1_18_R2, Map.of(2, "1.18.2"));
        versionMap.put(NMSVersion.v1_18_R1, Map.of(0, "1.18", 1, "1.18.1"));
        manifest = JarReader.getManifestContent();
        leaked = JarReader.checkIsLeaked();
    }

    public static enum NMSVersion {
        v1_20_R3,
        v1_20_R2,
        v1_20_R1,
        v1_19_R3,
        v1_19_R2,
        v1_19_R1,
        v1_18_R2,
        v1_18_R1,
        UNKNOWN;


        public static boolean matchesServer(String version) {
            return VersionUtil.getNMSVersion(VersionUtil.getMinecraftVersion()).equals((Object)VersionUtil.getNMSVersion(version));
        }

        public static boolean matchesServer(NMSVersion version) {
            return version != UNKNOWN && VersionUtil.getNMSVersion(VersionUtil.getMinecraftVersion()).equals((Object)version);
        }
    }
}

