/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.drops.Drop;
import java.util.function.Consumer;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtils {
    public static ItemStack editItemMeta(ItemStack itemStack, Consumer<ItemMeta> function) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        function.accept(meta);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack damageItem(Player player, Drop drop, ItemStack itemStack) {
        if (drop == null) {
            return itemStack;
        }
        boolean isToolEnough = drop.isToolEnough(itemStack);
        int damage = isToolEnough ? 1 : 2;
        int n = damage = ItemUtils.isTool(itemStack) ? damage : 0;
        if (damage == 0) {
            return itemStack;
        }
        try {
            return player.damageItemStack(itemStack, damage);
        }
        catch (Exception e) {
            int finalDamage = damage;
            return ItemUtils.editItemMeta(itemStack, meta -> {
                if (meta instanceof Damageable) {
                    Damageable damageable = (Damageable)meta;
                    if (EventUtils.callEvent((Event)new PlayerItemDamageEvent(player, itemStack, finalDamage))) {
                        damageable.setDamage(damageable.getDamage() + 1);
                    }
                }
            });
        }
    }

    public static boolean isTool(ItemStack itemStack) {
        return ItemUtils.isTool(itemStack.getType());
    }

    public static boolean isTool(Material material) {
        if (VersionUtil.isSupportedVersionOrNewer("1.19.4")) {
            return Tag.ITEMS_TOOLS.isTagged((Keyed)material);
        }
        return material.toString().endsWith("_AXE") || material.toString().endsWith("_PICKAXE") || material.toString().endsWith("_SHOVEL") || material.toString().endsWith("_HOE") || material.toString().endsWith("_SWORD") || material == Material.TRIDENT;
    }
}

