/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.hud;

import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.ConfigsManager;
import io.th0rgal.oraxen.hud.Hud;
import io.th0rgal.oraxen.hud.HudEvents;
import io.th0rgal.oraxen.hud.HudTask;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HudManager {
    public final int hudUpdateTime;
    public final NamespacedKey hudToggleKey;
    public final NamespacedKey hudDisplayKey;
    private final HudEvents hudEvents;
    private static HudTask hudTask;
    private static boolean hudTaskEnabled;
    private final Map<String, Hud> huds;
    public Map<Hud, String> parsedHudDisplays;

    public HudManager(ConfigsManager hudManager) {
        ConfigurationSection hudSection = this.getHudConfigSection();
        this.hudUpdateTime = hudManager.getHud().getInt("update_time_in_ticks", 40);
        this.hudEvents = new HudEvents();
        hudTaskEnabled = false;
        this.hudToggleKey = new NamespacedKey((Plugin)OraxenPlugin.get(), "hud_toggle");
        this.hudDisplayKey = new NamespacedKey((Plugin)OraxenPlugin.get(), "hud_display");
        this.huds = new HashMap<String, Hud>();
        if (hudSection != null) {
            this.loadHuds(hudSection);
        }
    }

    public ConfigurationSection getHudConfigSection() {
        return OraxenPlugin.get().getConfigsManager().getHud().getConfigurationSection("huds");
    }

    public void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)this.hudEvents, (Plugin)OraxenPlugin.get());
    }

    public void unregisterEvents() {
        HandlerList.unregisterAll((Listener)this.hudEvents);
    }

    public void reregisterEvents() {
        this.unregisterEvents();
        this.registerEvents();
    }

    public final Map<String, Hud> getHuds() {
        return this.huds;
    }

    public Hud getHudFromID(String id) {
        return this.huds.get(id);
    }

    public String getHudID(Hud hud) {
        for (Map.Entry<String, Hud> entry : this.huds.entrySet()) {
            if (!entry.getValue().equals(hud)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Hud getActiveHudForPlayer(Player player) {
        return this.huds.get(player.getPersistentDataContainer().get(this.hudDisplayKey, DataType.STRING));
    }

    public void setActiveHudForPlayer(Player player, Hud hud) {
        player.getPersistentDataContainer().set(this.hudDisplayKey, PersistentDataType.STRING, (Object)this.getHudID(hud));
    }

    public boolean getHudStateForPlayer(Player player) {
        return !Boolean.FALSE.equals(player.getPersistentDataContainer().get(this.hudToggleKey, DataType.BOOLEAN));
    }

    public void setHudStateForPlayer(Player player, boolean state) {
        player.getPersistentDataContainer().set(this.hudToggleKey, DataType.BOOLEAN, (Object)state);
    }

    public Collection<Hud> getDefaultEnabledHuds() {
        return this.huds.values().stream().filter(Hud::isEnabledByDefault).toList();
    }

    public void updateHud(Player player) {
        this.enableHud(player, this.getActiveHudForPlayer(player));
    }

    public void disableHud(Player player) {
        OraxenPlugin.get().getAudience().player(player).sendActionBar((Component)Component.empty());
    }

    public void enableHud(Player player, Hud hud) {
        if (hud == null || hud.getDisplayText() == null || !this.getHudStateForPlayer(player)) {
            return;
        }
        String hudDisplay = this.parsedHudDisplays.get(hud);
        hudDisplay = this.translatePlaceholdersForHudDisplay(player, hudDisplay);
        hudDisplay = AdventureUtils.parseLegacy(hudDisplay);
        OraxenPlugin.get().getAudience().player(player).sendActionBar(AdventureUtils.MINI_MESSAGE.deserialize((Object)hudDisplay));
    }

    public void registerTask() {
        if (hudTaskEnabled) {
            return;
        }
        if (hudTask != null) {
            hudTask.cancel();
        }
        if (this.hudUpdateTime == 0) {
            return;
        }
        if (this.huds.isEmpty()) {
            return;
        }
        hudTask = new HudTask();
        hudTask.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, this.hudUpdateTime);
        hudTaskEnabled = true;
    }

    public void unregisterTask() {
        if (!hudTaskEnabled) {
            return;
        }
        if (hudTask != null) {
            hudTask.cancel();
        }
        hudTaskEnabled = false;
    }

    public void restartTask() {
        this.unregisterTask();
        this.registerTask();
    }

    public void loadHuds(ConfigurationSection section) {
        if (section == null) {
            return;
        }
        for (String hudName : section.getKeys(false)) {
            ConfigurationSection hudSection = section.getConfigurationSection(hudName);
            if (hudSection == null || hudSection.getKeys(false).isEmpty()) continue;
            this.huds.clear();
            this.huds.put(hudName, new Hud(hudSection.getString("display_text"), hudSection.getString("text_font", "minecraft:default"), hudSection.getString("permission", ""), hudSection.getBoolean("disabled_whilst_in_water", false), hudSection.getBoolean("enabled_by_default", false), hudSection.getBoolean("enable_for_spectator_mode", false)));
        }
    }

    public Map<Hud, String> generateHudDisplays() {
        HashMap<Hud, String> hudDisplays = new HashMap<Hud, String>();
        for (Map.Entry<String, Hud> entry : this.huds.entrySet()) {
            hudDisplays.put(entry.getValue(), this.translateMiniMessageTagsForHud(entry.getValue()));
        }
        return hudDisplays;
    }

    private String translateMiniMessageTagsForHud(Hud hud) {
        return AdventureUtils.parseMiniMessage(hud.getDisplayText());
    }

    private String translatePlaceholdersForHudDisplay(Player player, String message) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
    }
}

