/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.FontManager;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class Glyph {
    public static final Character WHITESPACE_GLYPH = Character.valueOf('\ue000');
    private boolean fileChanged = false;
    private final String name;
    private final Key font = Key.key((String)"default");
    private final boolean isEmoji;
    private final boolean tabcomplete;
    private final Character character;
    private String texture;
    private final int ascent;
    private final int height;
    private final String permission;
    private final String[] placeholders;
    private final BitMapEntry bitmapEntry;
    public final Pattern baseRegex;
    public final Pattern escapedRegex;
    private final Set<String> materialNames = Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toSet());

    public Glyph(String glyphName, ConfigurationSection glyphSection, char newChars) {
        this.name = glyphName;
        this.isEmoji = glyphSection.getBoolean("is_emoji", false);
        ConfigurationSection chatSection = glyphSection.getConfigurationSection("chat");
        this.placeholders = chatSection != null ? chatSection.getStringList("placeholders").toArray(new String[0]) : new String[]{};
        this.permission = chatSection != null ? chatSection.getString("permission", "") : "";
        this.tabcomplete = chatSection != null && chatSection.getBoolean("tabcomplete", false);
        String baseRegex = "((<(glyph|g):" + this.name + ")(:(c|colorable))*>" + (String)(this.placeholders.length > 0 ? "|" + String.join((CharSequence)"|", this.placeholders) : "") + ")";
        this.baseRegex = Pattern.compile("(?<!\\\\)" + baseRegex);
        this.escapedRegex = Pattern.compile("\\\\" + baseRegex);
        if (glyphSection.contains("code")) {
            if (glyphSection.isInt("code")) {
                glyphSection.set("char", (Object)Character.valueOf((char)glyphSection.getInt("code")));
            }
            glyphSection.set("code", null);
            this.fileChanged = true;
        }
        if (!glyphSection.contains("char") && !Settings.DISABLE_AUTOMATIC_GLYPH_CODE.toBool().booleanValue()) {
            glyphSection.set("char", (Object)Character.valueOf(newChars));
            this.fileChanged = true;
        }
        this.character = glyphSection.get("char") != null ? Character.valueOf(glyphSection.getString("char", "").charAt(0)) : null;
        ConfigurationSection bitmapSection = glyphSection.getConfigurationSection("bitmap");
        this.bitmapEntry = bitmapSection != null ? new BitMapEntry(bitmapSection.getString("id"), bitmapSection.getInt("row"), bitmapSection.getInt("column")) : null;
        this.ascent = this.getBitMap() != null ? this.getBitMap().ascent() : glyphSection.getInt("ascent", 8);
        this.height = this.getBitMap() != null ? this.getBitMap().height() : glyphSection.getInt("height", 8);
        String string = this.texture = this.getBitMap() != null ? this.getBitMap().texture() : glyphSection.getString("texture", "required/exit_icon.png");
        if (!this.texture.endsWith(".png")) {
            this.texture = this.texture + ".png";
        }
    }

    public BitMapEntry getBitmapEntry() {
        return this.bitmapEntry;
    }

    public String getBitmapId() {
        return this.bitmapEntry != null ? this.bitmapEntry.id : null;
    }

    public boolean hasBitmap() {
        return this.getBitmapId() != null;
    }

    public boolean isBitMap() {
        return FontManager.getGlyphBitMap(this.getBitmapId()) != null;
    }

    public FontManager.GlyphBitMap getBitMap() {
        return FontManager.getGlyphBitMap(this.getBitmapId());
    }

    public boolean isFileChanged() {
        return this.fileChanged;
    }

    public String getName() {
        return this.name;
    }

    public String getCharacter() {
        return this.character != null ? this.character.toString() : "";
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTexture(String texture) {
        this.texture = texture.endsWith(".png") ? texture : texture + ".png";
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getHeight() {
        return this.height;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getPlaceholders() {
        return this.placeholders;
    }

    public boolean isEmoji() {
        return this.isEmoji;
    }

    public boolean hasTabCompletion() {
        return this.tabcomplete;
    }

    public JsonObject toJson() {
        JsonObject output = new JsonObject();
        JsonArray chars = new JsonArray();
        chars.add(this.getCharacter());
        output.add("chars", (JsonElement)chars);
        output.addProperty("file", this.texture);
        output.addProperty("ascent", (Number)this.ascent);
        output.addProperty("height", (Number)this.height);
        output.addProperty("type", "bitmap");
        return output;
    }

    public boolean hasPermission(Player player) {
        return player == null || this.permission.isEmpty() || player.hasPermission(this.permission);
    }

    /*
     * Unable to fully structure code
     */
    public void verifyGlyph(List<Glyph> glyphs) {
        packFolder = Path.of(OraxenPlugin.get().getDataFolder().getAbsolutePath(), new String[0]).resolve("pack");
        if (!packFolder.toFile().exists()) {
            return;
        }
        texturePath = this.texture.contains(":") != false ? "assets/" + StringUtils.substringBefore((String)this.texture, (String)":") + "/textures/" : "textures/";
        texturePath = (String)texturePath + (this.texture.contains(":") != false ? this.texture.split(":")[1] : this.texture);
        if (!StringUtils.substringBefore((String)this.texture, (String)":").equals("minecraft") || packFolder.resolve((String)texturePath).toFile().exists()) {
            textureFile = packFolder.resolve((String)texturePath).toFile();
            if (!textureFile.exists()) {
                textureFile = packFolder.resolve("assets/minecraft/" + (String)texturePath).toFile();
            }
        } else {
            textureFile = packFolder.resolve(texturePath.replace("assets/minecraft/", "")).toFile();
        }
        sameCharMap = glyphs.stream().filter((Predicate<Glyph>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verifyGlyph$0(io.th0rgal.oraxen.font.Glyph ), (Lio/th0rgal/oraxen/font/Glyph;)Z)((Glyph)this)).collect(Collectors.toMap((Function<Glyph, Glyph>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$verifyGlyph$1(io.th0rgal.oraxen.font.Glyph ), (Lio/th0rgal/oraxen/font/Glyph;)Lio/th0rgal/oraxen/font/Glyph;)(), (Function<Glyph, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$verifyGlyph$2(io.th0rgal.oraxen.font.Glyph ), (Lio/th0rgal/oraxen/font/Glyph;)Ljava/lang/Boolean;)()));
        isMinecraftNamespace = this.texture.contains(":") == false || this.texture.split(":")[0].equals("minecraft") != false;
        textureName = textureFile.getName().split("\\.")[0].toUpperCase();
        if (!isMinecraftNamespace) ** GOTO lbl-1000
        if (this.materialNames.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)textureName))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isVanillaTexture = v0;
        hasUpperCase = false;
        image = null;
        for (char c : texturePath.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            hasUpperCase = true;
        }
        try {
            image = ImageIO.read(textureFile);
        }
        catch (IOException var11_12) {
            // empty catch block
        }
        if (this.height < this.ascent) {
            this.setTexture("required/exit_icon");
            Logs.logError("The ascent is bigger than the height for " + this.name + ". This will break all your glyphs.");
            Logs.logWarning("It has been temporarily set to a placeholder image. You should edit this in the glyph config.");
        } else if (!(isVanillaTexture || textureFile.exists() && image != null)) {
            this.setTexture("required/exit_icon");
            Logs.logError("The texture specified for " + this.name + " does not exist. This will break all your glyphs.");
            Logs.logWarning("It has been temporarily set to a placeholder image. You should edit this in the glyph config.");
        } else if (hasUpperCase) {
            this.setTexture("required/exit_icon");
            Logs.logError("The filename specified for " + this.name + " contains capital letters.");
            Logs.logWarning("This will break all your glyphs. It has been temporarily set to a placeholder image.");
            Logs.logWarning("You should edit this in the glyph config and your textures filename.");
        } else if (texturePath.contains(" ")) {
            this.setTexture("required/exit_icon");
            Logs.logError("The filename specified for " + this.name + " contains spaces.");
            Logs.logWarning("This will break all your glyphs. It has been temporarily set to a placeholder image.");
            Logs.logWarning("You should replace spaces with _ in your filename and glyph config.");
        } else if (texturePath.contains("//")) {
            this.setTexture("required/exit_icon");
            Logs.logError("The filename specified for " + this.name + " contains double slashes.");
            Logs.logWarning("This will break all your glyphs. It has been temporarily set to a placeholder image.");
            Logs.logWarning("You should make sure that the texture-path you have specified is correct.");
        } else if (!(isVanillaTexture || this.isBitMap() || image.getHeight() <= 256 && image.getWidth() <= 256)) {
            this.setTexture("required/exit_icon");
            Logs.logError("The texture specified for " + this.name + " is larger than the supported size.");
            Logs.logWarning("The maximum image size is 256x256. Anything bigger will break all your glyphs.");
            Logs.logWarning("It has been temporarily set to a placeholder-image. You should edit this in the glyph config.");
        } else if (Settings.DISABLE_AUTOMATIC_GLYPH_CODE.toBool().booleanValue() && !sameCharMap.isEmpty()) {
            this.setTexture("required/exit_icon");
            Logs.logError(this.name + " code is the same as " + sameCharMap.keySet().stream().map((Function<Glyph, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lio/th0rgal/oraxen/font/Glyph;)Ljava/lang/String;)()).collect(Collectors.joining(", ")) + ".");
            Logs.logWarning("This will break all your glyphs. It has been temporarily set to a placeholder image.");
            Logs.logWarning("You should edit the code of all these glyphs to be unique.");
        }
    }

    public String getGlyphTag() {
        return "<glyph;" + this.name + ">";
    }

    public String getShortGlyphTag() {
        return "<g:" + this.name + ">";
    }

    public Component getGlyphComponent() {
        return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)this.getCharacter(), (TextColor)NamedTextColor.WHITE).font(this.font)});
    }

    private static /* synthetic */ Boolean lambda$verifyGlyph$2(Glyph g) {
        return true;
    }

    private static /* synthetic */ Glyph lambda$verifyGlyph$1(Glyph g) {
        return g;
    }

    private /* synthetic */ boolean lambda$verifyGlyph$0(Glyph g) {
        return !g.name.equals(this.name) && !g.getCharacter().isBlank() && g.character.equals(this.character);
    }

    public record BitMapEntry(String id, int row, int column) {
    }
}

