/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.config;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.ResourcesManager;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemParser;
import io.th0rgal.oraxen.items.ItemTemplate;
import io.th0rgal.oraxen.items.ModelData;
import io.th0rgal.oraxen.pack.generation.DuplicationHandler;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigsManager {
    private final JavaPlugin plugin;
    private final YamlConfiguration defaultMechanics;
    private final YamlConfiguration defaultSettings;
    private final YamlConfiguration defaultFont;
    private final YamlConfiguration defaultSound;
    private final YamlConfiguration defaultLanguage;
    private final YamlConfiguration defaultHud;
    private YamlConfiguration mechanics;
    private YamlConfiguration settings;
    private YamlConfiguration font;
    private YamlConfiguration sound;
    private YamlConfiguration language;
    private YamlConfiguration hud;
    private File itemsFolder;
    private File glyphsFolder;
    private File schematicsFolder;
    private File gesturesFolder;
    private final List<String> skippedYamlKeys = List.of("oraxen_inventory.menu_layout", "Misc.armor_equip_event_bypass");
    private final List<String> removedYamlKeys = List.of("armorpotioneffects");

    public ConfigsManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultMechanics = this.extractDefault("mechanics.yml");
        this.defaultSettings = this.extractDefault("settings.yml");
        this.defaultFont = this.extractDefault("font.yml");
        this.defaultSound = this.extractDefault("sound.yml");
        this.defaultLanguage = this.extractDefault("languages/english.yml");
        this.defaultHud = this.extractDefault("hud.yml");
    }

    public YamlConfiguration getMechanics() {
        return this.mechanics != null ? this.mechanics : this.defaultMechanics;
    }

    public YamlConfiguration getSettings() {
        return this.settings != null ? this.settings : this.defaultSettings;
    }

    public File getSettingsFile() {
        return new File(this.plugin.getDataFolder(), "settings.yml");
    }

    public YamlConfiguration getLanguage() {
        return this.language != null ? this.language : this.defaultLanguage;
    }

    public YamlConfiguration getFont() {
        return this.font != null ? this.font : this.defaultFont;
    }

    public YamlConfiguration getHud() {
        return this.hud != null ? this.hud : this.defaultHud;
    }

    public YamlConfiguration getSound() {
        return this.sound != null ? this.sound : this.defaultSound;
    }

    public File getSchematicsFolder() {
        return this.schematicsFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YamlConfiguration extractDefault(String source) {
        InputStreamReader inputStreamReader = new InputStreamReader(this.plugin.getResource(source));
        try {
            YamlConfiguration yamlConfiguration = OraxenYaml.loadConfiguration((Reader)inputStreamReader);
            return yamlConfiguration;
        }
        finally {
            block7: {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    Logs.logError("Failed to extract default file: " + source);
                    if (!Settings.DEBUG.toBool().booleanValue()) break block7;
                    e.printStackTrace();
                }
            }
        }
    }

    public void validatesConfig() {
        ResourcesManager tempManager = new ResourcesManager(OraxenPlugin.get());
        this.mechanics = this.validate(tempManager, "mechanics.yml", this.defaultMechanics);
        this.settings = this.validate(tempManager, "settings.yml", this.defaultSettings);
        this.font = this.validate(tempManager, "font.yml", this.defaultFont);
        this.hud = this.validate(tempManager, "hud.yml", this.defaultHud);
        this.sound = this.validate(tempManager, "sound.yml", this.defaultSound);
        File languagesFolder = new File(this.plugin.getDataFolder(), "languages");
        languagesFolder.mkdir();
        String languageFile = "languages/" + this.settings.getString(Settings.PLUGIN_LANGUAGE.getPath()) + ".yml";
        this.language = this.validate(tempManager, languageFile, this.defaultLanguage);
        this.itemsFolder = new File(this.plugin.getDataFolder(), "items");
        if (!this.itemsFolder.exists()) {
            this.itemsFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                tempManager.extractConfigsInFolder("items", "yml");
            }
        }
        this.glyphsFolder = new File(this.plugin.getDataFolder(), "glyphs");
        if (!this.glyphsFolder.exists()) {
            this.glyphsFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                tempManager.extractConfigsInFolder("glyphs", "yml");
            } else {
                tempManager.extractConfiguration("glyphs/interface.yml");
            }
        }
        this.schematicsFolder = new File(this.plugin.getDataFolder(), "schematics");
        if (!this.schematicsFolder.exists()) {
            this.schematicsFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                tempManager.extractConfigsInFolder("schematics", "schem");
            }
        }
        this.gesturesFolder = new File(this.plugin.getDataFolder(), "gestures");
        if (!this.gesturesFolder.exists()) {
            this.gesturesFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                tempManager.extractConfigsInFolder("gestures", "yml");
            }
        }
    }

    private YamlConfiguration validate(ResourcesManager resourcesManager, String configName, YamlConfiguration defaultConfiguration) {
        YamlConfiguration configuration;
        block5: {
            File configurationFile = resourcesManager.extractConfiguration(configName);
            configuration = OraxenYaml.loadConfiguration(configurationFile);
            boolean updated = false;
            for (String key : defaultConfiguration.getKeys(true)) {
                if (!this.skippedYamlKeys.stream().filter(key::startsWith).toList().isEmpty() || configuration.get(key) != null) continue;
                updated = true;
                Message.UPDATING_CONFIG.log(AdventureUtils.tagResolver("option", key));
                configuration.set(key, defaultConfiguration.get(key));
            }
            for (String key : configuration.getKeys(false)) {
                if (!this.removedYamlKeys.contains(key)) continue;
                updated = true;
                Message.REMOVING_CONFIG.log(AdventureUtils.tagResolver("option", key));
                configuration.set(key, null);
            }
            if (updated) {
                try {
                    configuration.save(configurationFile);
                }
                catch (IOException e) {
                    Logs.logError("Failed to save updated configuration file: " + configurationFile.getName());
                    if (!Settings.DEBUG.toBool().booleanValue()) break block5;
                    e.printStackTrace();
                }
            }
        }
        return configuration;
    }

    public Collection<Glyph> parseGlyphConfigs() {
        YamlConfiguration configuration;
        List<File> glyphFiles = this.getGlyphFiles();
        ArrayList<Glyph> output = new ArrayList<Glyph>();
        HashMap<String, Character> charPerGlyph = new HashMap<String, Character>();
        for (File file : glyphFiles) {
            configuration = OraxenYaml.loadConfiguration(file);
            for (Object key : configuration.getKeys(false)) {
                String characterString;
                char character;
                ConfigurationSection glyphSection = configuration.getConfigurationSection((String)key);
                if (glyphSection == null || (character = !(characterString = glyphSection.getString("char", "")).isBlank() ? characterString.charAt(0) : (char)'\u0000') == '\u0000') continue;
                charPerGlyph.put((String)key, Character.valueOf(character));
            }
        }
        for (File file : glyphFiles) {
            configuration = OraxenYaml.loadConfiguration(file);
            boolean fileChanged = false;
            for (String key : configuration.getKeys(false)) {
                Glyph glyph;
                char character = charPerGlyph.getOrDefault(key, Character.valueOf('\u0000')).charValue();
                if (character == '\u0000') {
                    character = Utils.firstEmpty(charPerGlyph, 42000);
                    charPerGlyph.put(key, Character.valueOf(character));
                }
                if ((glyph = new Glyph(key, configuration.getConfigurationSection(key), character)).isFileChanged()) {
                    fileChanged = true;
                }
                glyph.verifyGlyph(output);
                output.add(glyph);
            }
            if (!fileChanged || Settings.DISABLE_AUTOMATIC_GLYPH_CODE.toBool().booleanValue()) continue;
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                Logs.logWarning("Failed to save updated glyph file: " + file.getName());
                if (!Settings.DEBUG.toBool().booleanValue()) continue;
                e.printStackTrace();
            }
        }
        return output;
    }

    public Map<File, Map<String, ItemBuilder>> parseItemConfig() {
        LinkedHashMap<File, Map<String, ItemBuilder>> parseMap = new LinkedHashMap<File, Map<String, ItemBuilder>>();
        for (File file : this.getItemFiles()) {
            parseMap.put(file, this.parseItemConfig(file));
        }
        return parseMap;
    }

    public void assignAllUsedModelDatas() {
        HashMap<Material, Map> assignedModelDatas = new HashMap<Material, Map>();
        for (File file : this.getItemFiles()) {
            if (!file.exists()) continue;
            YamlConfiguration configuration = OraxenYaml.loadConfiguration(file);
            boolean fileChanged = false;
            for (String key : configuration.getKeys(false)) {
                ConfigurationSection itemSection = configuration.getConfigurationSection(key);
                if (itemSection == null) continue;
                ConfigurationSection packSection = itemSection.getConfigurationSection("Pack");
                Material material = Material.getMaterial((String)itemSection.getString("material", ""));
                if (packSection == null || material == null) continue;
                int modelData = packSection.getInt("custom_model_data", -1);
                String model = this.getItemModelFromConfigurationSection(packSection);
                if (modelData == -1) continue;
                if (assignedModelDatas.containsKey(material) && ((Map)assignedModelDatas.get(material)).containsKey(modelData)) {
                    if (((String)((Map)assignedModelDatas.get(material)).get(modelData)).equals(model)) continue;
                    Logs.logError("CustomModelData " + modelData + " is already assigned to another item with this material but different model");
                    if (file.getAbsolutePath().equals(DuplicationHandler.getDuplicateItemFile(material).getAbsolutePath()) && Settings.RETAIN_CUSTOM_MODEL_DATA.toBool().booleanValue()) {
                        Logs.logWarning("Due to " + Settings.RETAIN_CUSTOM_MODEL_DATA.getPath() + " being enabled,");
                        Logs.logWarning("the model data will not removed from " + file.getName() + ": " + key + ".");
                        Logs.logWarning("There will still be a conflict which you need to solve yourself.");
                        Logs.logWarning("Either reset the CustomModelData of this item, or change the CustomModelData of the conflicting item.", true);
                        continue;
                    }
                    Logs.logWarning("Removing custom model data from " + file.getName() + ": " + key, true);
                    packSection.set("custom_model_data", null);
                    fileChanged = true;
                    continue;
                }
                assignedModelDatas.computeIfAbsent(material, k -> new HashMap()).put(modelData, model);
                ModelData.DATAS.computeIfAbsent(material, k -> new HashMap()).put(key, modelData);
            }
            if (!fileChanged) continue;
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void parseAllItemTemplates() {
        for (File file : this.getItemFiles()) {
            if (!file.exists()) continue;
            YamlConfiguration configuration = OraxenYaml.loadConfiguration(file);
            for (String key : configuration.getKeys(false)) {
                ConfigurationSection itemSection = configuration.getConfigurationSection(key);
                if (itemSection == null || !itemSection.isBoolean("template")) continue;
                new ItemTemplate(itemSection);
            }
        }
    }

    private String getItemModelFromConfigurationSection(ConfigurationSection packSection) {
        String model = packSection.getString("model", "");
        if (model.isEmpty() && packSection.getBoolean("generate_model", false)) {
            model = packSection.getParent().getName();
        }
        return model;
    }

    public Map<String, ItemBuilder> parseItemConfig(File itemFile) {
        YamlConfiguration config = OraxenYaml.loadConfiguration(itemFile);
        LinkedHashMap<String, ItemParser> parseMap = new LinkedHashMap<String, ItemParser>();
        ItemParser errorItem = new ItemParser(Settings.ERROR_ITEM.toConfigSection());
        for (String itemKey : config.getKeys(false)) {
            ConfigurationSection itemSection = config.getConfigurationSection(itemKey);
            if (itemSection == null || ItemTemplate.isTemplate(itemKey)) continue;
            parseMap.put(itemKey, new ItemParser(itemSection));
        }
        boolean configUpdated = false;
        LinkedHashMap<String, ItemBuilder> map = new LinkedHashMap<String, ItemBuilder>();
        for (Map.Entry entry : parseMap.entrySet()) {
            ItemParser itemParser = (ItemParser)entry.getValue();
            try {
                map.put((String)entry.getKey(), itemParser.buildItem());
            }
            catch (Exception e) {
                map.put((String)entry.getKey(), errorItem.buildItem());
                Logs.logError("ERROR BUILDING ITEM \"" + (String)entry.getKey() + "\"");
                if (Settings.DEBUG.toBool().booleanValue()) {
                    e.printStackTrace();
                }
                Logs.logWarning(e.getMessage());
            }
            if (!itemParser.isConfigUpdated()) continue;
            configUpdated = true;
        }
        if (configUpdated) {
            try {
                config.save(itemFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    private List<File> getItemFiles() {
        if (this.itemsFolder == null || !this.itemsFolder.exists()) {
            return new ArrayList<File>();
        }
        return FileUtils.listFiles((File)this.itemsFolder, (String[])new String[]{"yml"}, (boolean)true).stream().filter(OraxenYaml::isValidYaml).sorted().toList();
    }

    private List<File> getGlyphFiles() {
        if (this.glyphsFolder == null || !this.glyphsFolder.exists()) {
            return new ArrayList<File>();
        }
        return FileUtils.listFiles((File)this.glyphsFolder, (String[])new String[]{"yml"}, (boolean)true).stream().filter(OraxenYaml::isValidYaml).sorted().toList();
    }
}

