/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.recipes.CustomRecipe;
import io.th0rgal.oraxen.recipes.builders.BlastingBuilder;
import io.th0rgal.oraxen.recipes.builders.CampfireBuilder;
import io.th0rgal.oraxen.recipes.builders.FurnaceBuilder;
import io.th0rgal.oraxen.recipes.builders.RecipeBuilder;
import io.th0rgal.oraxen.recipes.builders.ShapedBuilder;
import io.th0rgal.oraxen.recipes.builders.ShapelessBuilder;
import io.th0rgal.oraxen.recipes.builders.SmokingBuilder;
import io.th0rgal.oraxen.recipes.builders.StonecuttingBuilder;
import io.th0rgal.oraxen.recipes.listeners.RecipesEventsManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.List;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class RecipesCommand {
    CommandAPICommand getRecipesCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("recipes").withPermission("oraxen.command.recipes")).withSubcommand((AbstractCommandAPICommand)this.getShowCommand())).withSubcommand((AbstractCommandAPICommand)this.getBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getSaveCommand());
    }

    private CommandAPICommand getShowCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("show").withPermission("oraxen.command.recipes.show")).withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings(info -> (String[])ArrayUtils.addAll((Object[])new String[]{"all"}, (Object[])RecipesEventsManager.get().getPermittedRecipesName((CommandSender)info.sender()))))})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                List<CustomRecipe> recipes = RecipesEventsManager.get().getPermittedRecipes((CommandSender)player);
                String param = (String)args.get("type");
                if (!"all".equals(param)) {
                    recipes = recipes.stream().filter(customRecipe -> customRecipe.getName().equals(param)).toList();
                }
                if (recipes.isEmpty()) {
                    Message.RECIPE_NO_RECIPE.send(sender, new TagResolver[0]);
                    return;
                }
                OraxenPlugin.get().getInvManager().getRecipesShowcase(player, 0, recipes).show((HumanEntity)player);
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("builder").withPermission("oraxen.command.recipes.builder")).withSubcommand((AbstractCommandAPICommand)this.getShapedBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getShapelessBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getFurnaceBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getBlastingBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getCampfireBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getSmokingBuilderCommand())).withSubcommand((AbstractCommandAPICommand)this.getStonecuttingBuilderCommand())).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                if (recipe != null) {
                    recipe.open();
                } else {
                    Message.RECIPE_NO_BUILDER.send(sender, new TagResolver[0]);
                }
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getShapedBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("shaped").withPermission("oraxen.command.recipes.builder")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                (recipe != null ? recipe : new ShapedBuilder(player)).open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getShapelessBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("shapeless").withPermission("oraxen.command.recipes.builder")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                (recipe != null ? recipe : new ShapelessBuilder(player)).open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getFurnaceBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("furnace").withPermission("oraxen.command.recipes.builder")).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("cookingtime")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("experience")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                RecipeBuilder recipeBuilder = recipe = recipe != null ? recipe : new FurnaceBuilder(player);
                if (recipe instanceof FurnaceBuilder) {
                    FurnaceBuilder furnace = (FurnaceBuilder)recipe;
                    furnace.setCookingTime((Integer)args.get("cookingtime"));
                    furnace.setExperience((Integer)args.get("experience"));
                }
                recipe.open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getBlastingBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("blasting").withPermission("oraxen.command.recipes.builder")).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("cookingtime")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("experience")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                RecipeBuilder recipeBuilder = recipe = recipe != null ? recipe : new BlastingBuilder(player);
                if (recipe instanceof BlastingBuilder) {
                    BlastingBuilder blasting = (BlastingBuilder)recipe;
                    blasting.setCookingTime((Integer)args.get("cookingtime"));
                    blasting.setExperience((Integer)args.get("experience"));
                }
                recipe.open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getCampfireBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("campfire").withPermission("oraxen.command.recipes.builder")).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("cookingtime")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("experience")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                RecipeBuilder recipeBuilder = recipe = recipe != null ? recipe : new CampfireBuilder(player);
                if (recipe instanceof CampfireBuilder) {
                    CampfireBuilder campfire = (CampfireBuilder)recipe;
                    campfire.setCookingTime((Integer)args.get("cookingtime"));
                    campfire.setExperience((Integer)args.get("experience"));
                }
                recipe.open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getSmokingBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("smoking").withPermission("oraxen.command.recipes.builder")).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("cookingtime")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("experience")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                RecipeBuilder recipeBuilder = recipe = recipe != null ? recipe : new SmokingBuilder(player);
                if (recipe instanceof SmokingBuilder) {
                    SmokingBuilder smoking = (SmokingBuilder)recipe;
                    smoking.setCookingTime((Integer)args.get("cookingtime"));
                    smoking.setExperience((Integer)args.get("experience"));
                }
                recipe.open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getStonecuttingBuilderCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("stonecutting").withPermission("oraxen.command.recipes.builder")).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                (recipe != null ? recipe : new StonecuttingBuilder(player)).open();
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getSaveCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("save").withPermission("oraxen.command.recipes.builder")).withArguments((AbstractArgument[])new Argument[]{new TextArgument("name")})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                RecipeBuilder recipe = RecipeBuilder.get(player.getUniqueId());
                if (recipe == null) {
                    Message.RECIPE_NO_BUILDER.send(sender, new TagResolver[0]);
                    return;
                }
                String name = (String)args.args()[0];
                recipe.saveRecipe(name);
                Message.RECIPE_SAVE.send(sender, AdventureUtils.tagResolver("name", name));
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }
}

