/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.drops;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.itemtype.ItemTypeMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.itemtype.ItemTypeMechanicFactory;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.drops.Loot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Drop {
    private List<String> hierarchy;
    private final List<Loot> loots;
    final boolean silktouch;
    final boolean fortune;
    String minimalType;
    private final List<String> bestTools;
    final String sourceID;

    public static Drop createDrop(List<String> toolTypes, @NotNull ConfigurationSection dropSection, String itemID) {
        List<Loot> loots = dropSection.getList("loots", new ArrayList()).stream().map(Loot::new).toList();
        return new Drop(toolTypes, loots, dropSection.getBoolean("silktouch"), dropSection.getBoolean("fortune"), itemID, dropSection.getString("minimal_type", ""), dropSection.getStringList("best_tools"));
    }

    public Drop(List<String> hierarchy, List<Loot> loots, boolean silktouch, boolean fortune, String sourceID, String minimalType, List<String> bestTools) {
        this.hierarchy = hierarchy;
        this.loots = loots;
        this.silktouch = silktouch;
        this.fortune = fortune;
        this.sourceID = sourceID;
        this.minimalType = minimalType;
        this.bestTools = bestTools;
    }

    public Drop(List<Loot> loots, boolean silktouch, boolean fortune, String sourceID) {
        this.loots = loots;
        this.silktouch = silktouch;
        this.fortune = fortune;
        this.sourceID = sourceID;
        this.bestTools = new ArrayList<String>();
    }

    public static Drop emptyDrop() {
        return new Drop(new ArrayList<Loot>(), false, false, "");
    }

    public static Drop emptyDrop(List<Loot> loots) {
        return new Drop(loots, false, false, "");
    }

    public static Drop clone(Drop drop, List<Loot> newLoots) {
        return new Drop(drop.hierarchy, newLoots, drop.silktouch, drop.fortune, drop.sourceID, drop.minimalType, drop.bestTools);
    }

    public String getItemType(ItemStack itemInHand) {
        String itemID = OraxenItems.getIdByItem(itemInHand);
        ItemTypeMechanicFactory factory = ItemTypeMechanicFactory.get();
        if (factory == null || factory.isNotImplementedIn(itemID)) {
            String[] content = itemInHand.getType().toString().split("_");
            return content.length >= 2 ? content[0] : "";
        }
        ItemTypeMechanic mechanic = (ItemTypeMechanic)factory.getMechanic(itemID);
        return mechanic.itemType;
    }

    public boolean canDrop(ItemStack itemInHand) {
        return this.isToolEnough(itemInHand) && this.isTypeEnough(itemInHand);
    }

    public boolean isTypeEnough(ItemStack itemInHand) {
        if (this.minimalType != null && !this.minimalType.isEmpty()) {
            String itemType = itemInHand == null ? "" : this.getItemType(itemInHand);
            return !itemType.isEmpty() && this.hierarchy.contains(itemType) && this.hierarchy.indexOf(itemType) >= this.hierarchy.indexOf(this.minimalType);
        }
        return true;
    }

    public boolean isToolEnough(ItemStack itemInHand) {
        if (!this.bestTools.isEmpty()) {
            String type;
            String itemID = OraxenItems.getIdByItem(itemInHand);
            String string = type = itemInHand == null ? Material.AIR.toString() : itemInHand.getType().toString().toUpperCase();
            if (itemID != null) {
                if (this.bestTools.stream().anyMatch(itemID::equalsIgnoreCase)) {
                    return true;
                }
            }
            if (this.bestTools.contains(type)) {
                return true;
            }
            return this.bestTools.stream().anyMatch(toolName -> type.endsWith(toolName.toUpperCase()));
        }
        return true;
    }

    public int getDiff(ItemStack item) {
        return this.minimalType == null ? 0 : this.hierarchy.indexOf(this.getItemType(item)) - this.hierarchy.indexOf(this.minimalType);
    }

    public boolean isSilktouch() {
        return this.silktouch;
    }

    public boolean isFortune() {
        return this.fortune;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public String getMinimalType() {
        return this.minimalType;
    }

    public List<String> getBestTools() {
        return this.bestTools;
    }

    public List<String> getHierarchy() {
        return this.hierarchy;
    }

    public List<Loot> getLoots() {
        return this.loots;
    }

    public Drop setLoots(List<Loot> loots) {
        this.loots.clear();
        this.loots.addAll(loots);
        return this;
    }

    public void spawns(Location location, ItemStack itemInHand) {
        if (!this.canDrop(itemInHand) || !BlockHelpers.isLoaded(location)) {
            return;
        }
        ItemStack baseItem = OraxenItems.getItemById(this.sourceID).build();
        if (this.silktouch && itemInHand.hasItemMeta() && itemInHand.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
            location.getWorld().dropItemNaturally(BlockHelpers.toCenterBlockLocation(location), baseItem);
        } else {
            this.dropLoot(this.loots, location, this.getFortuneMultiplier(itemInHand));
        }
    }

    public void furnitureSpawns(Entity baseEntity, ItemStack itemInHand) {
        ItemStack baseItem = OraxenItems.getItemById(this.sourceID).build();
        Location location = baseEntity.getLocation();
        ItemStack furnitureItem = FurnitureMechanic.getFurnitureItem(baseEntity);
        Utils.editItemMeta(furnitureItem, itemMeta -> {
            ItemMeta baseMeta = baseItem.getItemMeta();
            if (baseMeta != null && baseMeta.hasDisplayName()) {
                itemMeta.setDisplayName(baseMeta.getDisplayName());
            }
        });
        if (!this.canDrop(itemInHand) || !location.isWorldLoaded()) {
            return;
        }
        assert (location.getWorld() != null);
        if (this.silktouch && itemInHand.hasItemMeta() && itemInHand.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
            location.getWorld().dropItemNaturally(BlockHelpers.toCenterBlockLocation(location), baseItem);
        } else {
            this.dropLoot(this.loots.stream().filter(loot -> !loot.getItemStack().equals((Object)baseItem)).toList(), location, this.getFortuneMultiplier(itemInHand));
            this.dropLoot(this.loots.stream().filter(loot -> loot.getItemStack().equals((Object)baseItem)).map(loot -> new Loot(furnitureItem, loot.getProbability(), 1, loot.getMaxAmount())).toList(), location, this.getFortuneMultiplier(itemInHand));
        }
    }

    private int getFortuneMultiplier(ItemStack itemInHand) {
        ItemMeta itemMeta;
        int fortuneMultiplier = 1;
        if (itemInHand != null && (itemMeta = itemInHand.getItemMeta()) != null && this.fortune && itemMeta.hasEnchant(Enchantment.LOOT_BONUS_BLOCKS)) {
            fortuneMultiplier += ThreadLocalRandom.current().nextInt(itemMeta.getEnchantLevel(Enchantment.LOOT_BONUS_BLOCKS));
        }
        return fortuneMultiplier;
    }

    private void dropLoot(List<Loot> loots, Location location, int fortuneMultiplier) {
        for (Loot loot : loots) {
            loot.dropNaturally(location, fortuneMultiplier);
        }
    }

    public List<Loot> getLootToDrop(Player player) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        int fortuneMultiplier = this.getFortuneMultiplier(itemInHand);
        ArrayList<Loot> droppedLoots = new ArrayList<Loot>();
        for (Loot loot : this.loots) {
            ItemStack item = loot.getItem(fortuneMultiplier);
            if (!this.canDrop(itemInHand) || item == null || ThreadLocalRandom.current().nextInt(loot.getProbability()) != 0) continue;
            droppedLoots.add(loot);
        }
        return droppedLoots;
    }
}

