/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.armorequipevent;

import io.th0rgal.oraxen.utils.armorequipevent.ArmorEquipEvent;
import io.th0rgal.oraxen.utils.armorequipevent.ArmorType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ArmorListener
implements Listener {
    private final List<Material> blockedMaterials;

    public ArmorListener(List<String> blockedMaterialNames) {
        this.blockedMaterials = blockedMaterialNames.stream().map(Material::getMaterial).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onClick(InventoryClickEvent event) {
        boolean shift = false;
        boolean numberkey = false;
        Inventory clickedInventory = event.getClickedInventory();
        Inventory inventory = event.getInventory();
        InventoryType.SlotType slotType = event.getSlotType();
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
            shift = true;
        }
        if (event.getClick() == ClickType.NUMBER_KEY || event.getClick() == ClickType.SWAP_OFFHAND) {
            numberkey = true;
        }
        if (slotType != InventoryType.SlotType.ARMOR && slotType != InventoryType.SlotType.QUICKBAR && slotType != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (clickedInventory == null || clickedInventory.getType() != InventoryType.PLAYER) {
            return;
        }
        if (inventory.getType() != InventoryType.CRAFTING && inventory.getType() != InventoryType.PLAYER) {
            return;
        }
        ArmorType newArmorType = ArmorType.matchType(shift ? event.getCurrentItem() : event.getCursor());
        if (!shift && newArmorType != null && event.getRawSlot() != newArmorType.getSlot()) {
            return;
        }
        if (shift) {
            newArmorType = ArmorType.matchType(event.getCurrentItem());
            if (newArmorType != null) {
                boolean equipping;
                boolean bl = equipping = event.getRawSlot() != newArmorType.getSlot();
                if ((newArmorType.equals((Object)ArmorType.HELMET) && equipping == ArmorListener.isEmpty(event.getWhoClicked().getInventory().getHelmet()) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && equipping == ArmorListener.isEmpty(event.getWhoClicked().getInventory().getChestplate()) || newArmorType.equals((Object)ArmorType.LEGGINGS) && (!equipping ? !ArmorListener.isEmpty(event.getWhoClicked().getInventory().getLeggings()) : ArmorListener.isEmpty(event.getWhoClicked().getInventory().getLeggings())) || newArmorType.equals((Object)ArmorType.BOOTS) && (equipping ? ArmorListener.isEmpty(event.getWhoClicked().getInventory().getBoots()) : !ArmorListener.isEmpty(event.getWhoClicked().getInventory().getBoots()))) && !new ArmorEquipEvent((Player)event.getWhoClicked(), ArmorEquipEvent.EquipMethod.SHIFT_CLICK, newArmorType, equipping ? null : event.getCurrentItem(), equipping ? event.getCurrentItem() : null).callEvent()) {
                    event.setCancelled(true);
                }
            }
        } else {
            ItemStack newArmorPiece = event.getCursor();
            ItemStack oldArmorPiece = event.getCurrentItem();
            if (numberkey) {
                if (clickedInventory.getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = null;
                    if (event.getHotbarButton() != -1) {
                        hotbarItem = clickedInventory.getItem(event.getHotbarButton());
                    } else if (event.getHotbarButton() == -1 && clickedInventory instanceof PlayerInventory) {
                        PlayerInventory playerInventory = (PlayerInventory)clickedInventory;
                        hotbarItem = playerInventory.getItem(EquipmentSlot.OFF_HAND);
                    }
                    if (!ArmorListener.isEmpty(hotbarItem)) {
                        newArmorType = ArmorType.matchType(hotbarItem);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = clickedInventory.getItem(event.getSlot());
                    } else {
                        newArmorType = ArmorType.matchType(!ArmorListener.isEmpty(event.getCurrentItem()) ? event.getCurrentItem() : event.getCursor());
                    }
                }
            } else if (ArmorListener.isEmpty(event.getCursor()) && !ArmorListener.isEmpty(event.getCurrentItem())) {
                newArmorType = ArmorType.matchType(event.getCurrentItem());
            }
            if (newArmorType != null && event.getRawSlot() == newArmorType.getSlot()) {
                ArmorEquipEvent.EquipMethod method = ArmorEquipEvent.EquipMethod.PICK_DROP;
                if (event.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                    method = ArmorEquipEvent.EquipMethod.HOTBAR_SWAP;
                }
                if (!new ArmorEquipEvent((Player)event.getWhoClicked(), method, newArmorType, oldArmorPiece, newArmorPiece).callEvent()) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        if (event.useItemInHand().equals((Object)Event.Result.DENY)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!event.useInteractedBlock().equals((Object)Event.Result.DENY) && event.getClickedBlock() != null && event.getAction() == Action.RIGHT_CLICK_BLOCK && !player.isSneaking() && this.blockedMaterials.contains(event.getClickedBlock().getType())) {
            return;
        }
        EntityEquipment equipment = player.getEquipment();
        ArmorType newArmorType = ArmorType.matchType(event.getItem());
        if (event.getItem() != null && event.getItem().getType() == Material.CARVED_PUMPKIN) {
            return;
        }
        if (newArmorType == null || equipment == null) {
            return;
        }
        if (newArmorType == ArmorType.HELMET && !ArmorListener.isEmpty(equipment.getHelmet())) {
            return;
        }
        if (newArmorType == ArmorType.CHESTPLATE && !ArmorListener.isEmpty(equipment.getChestplate())) {
            return;
        }
        if (newArmorType == ArmorType.LEGGINGS && !ArmorListener.isEmpty(equipment.getLeggings())) {
            return;
        }
        if (newArmorType == ArmorType.BOOTS && !ArmorListener.isEmpty(equipment.getBoots())) {
            return;
        }
        if (!new ArmorEquipEvent(event.getPlayer(), ArmorEquipEvent.EquipMethod.HOTBAR, ArmorType.matchType(event.getItem()), null, event.getItem()).callEvent()) {
            event.setCancelled(true);
        }
    }

    static boolean isEmpty(ItemStack item) {
        return item == null || item.getType().isAir() || item.getAmount() == 0;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDrag(InventoryDragEvent event) {
        ArmorType type = ArmorType.matchType(event.getOldCursor());
        if (event.getRawSlots().isEmpty()) {
            return;
        }
        if (type != null && type.getSlot() == event.getRawSlots().stream().findFirst().orElse(0).intValue() && !new ArmorEquipEvent((Player)event.getWhoClicked(), ArmorEquipEvent.EquipMethod.DRAG, type, null, event.getOldCursor()).callEvent()) {
            event.setResult(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBreak(PlayerItemBreakEvent event) {
        ArmorType type = ArmorType.matchType(event.getBrokenItem());
        Player player = event.getPlayer();
        if (type == null) {
            return;
        }
        if (new ArmorEquipEvent(player, ArmorEquipEvent.EquipMethod.BROKE, type, event.getBrokenItem(), null).callEvent()) {
            return;
        }
        ItemStack i = event.getBrokenItem().clone();
        i.setAmount(1);
        i.setDurability((short)(i.getDurability() - 1));
        if (type.equals((Object)ArmorType.HELMET)) {
            player.getInventory().setHelmet(i);
        } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
            player.getInventory().setChestplate(i);
        } else if (type.equals((Object)ArmorType.LEGGINGS)) {
            player.getInventory().setLeggings(i);
        } else if (type.equals((Object)ArmorType.BOOTS)) {
            player.getInventory().setBoots(i);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        if (event.getKeepInventory()) {
            return;
        }
        for (ItemStack i : p.getInventory().getArmorContents()) {
            if (ArmorListener.isEmpty(i)) continue;
            new ArmorEquipEvent(p, ArmorEquipEvent.EquipMethod.DEATH, ArmorType.matchType(i), i, null).callEvent();
        }
    }
}

