/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.ResourcesManager;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.recipes.listeners.RecipesBuilderEvents;
import io.th0rgal.oraxen.recipes.listeners.RecipesEventsManager;
import io.th0rgal.oraxen.recipes.loaders.BlastingLoader;
import io.th0rgal.oraxen.recipes.loaders.CampfireLoader;
import io.th0rgal.oraxen.recipes.loaders.FurnaceLoader;
import io.th0rgal.oraxen.recipes.loaders.ShapedLoader;
import io.th0rgal.oraxen.recipes.loaders.ShapelessLoader;
import io.th0rgal.oraxen.recipes.loaders.SmokingLoader;
import io.th0rgal.oraxen.recipes.loaders.StonecuttingLoader;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RecipesManager {
    private RecipesManager() {
    }

    public static void load(JavaPlugin plugin) {
        if (Settings.RESET_RECIPES.toBool().booleanValue()) {
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                NamespacedKey recipeID = ((Keyed)recipeIterator.next()).getKey();
                if (!recipeID.getNamespace().equals("oraxen")) continue;
                Bukkit.removeRecipe((NamespacedKey)recipeID);
            }
        }
        Bukkit.getPluginManager().registerEvents((Listener)new RecipesBuilderEvents(), (Plugin)plugin);
        File recipesFolder = new File(OraxenPlugin.get().getDataFolder(), "recipes");
        if (!recipesFolder.exists()) {
            recipesFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                new ResourcesManager(plugin).extractConfigsInFolder("recipes", "yml");
            } else {
                try {
                    new File(recipesFolder, "furnace.yml").createNewFile();
                    new File(recipesFolder, "shaped.yml").createNewFile();
                    new File(recipesFolder, "shapeless.yml").createNewFile();
                    new File(recipesFolder, "blasting.yml").createNewFile();
                    new File(recipesFolder, "campfire.yml").createNewFile();
                    new File(recipesFolder, "smoking.yml").createNewFile();
                    new File(recipesFolder, "stonecutting.yml").createNewFile();
                }
                catch (IOException e) {
                    Logs.logError("Error while creating recipes files: " + e.getMessage());
                }
            }
        }
        RecipesManager.registerAllConfigRecipesFromFolder(recipesFolder);
        RecipesEventsManager.get().registerEvents();
    }

    public static void reload() {
        if (Settings.RESET_RECIPES.toBool().booleanValue()) {
            Iterator recipeIterator = Bukkit.recipeIterator();
            while (recipeIterator.hasNext()) {
                NamespacedKey recipeID = ((Keyed)recipeIterator.next()).getKey();
                if (!recipeID.getNamespace().equals("oraxen")) continue;
                Bukkit.removeRecipe((NamespacedKey)recipeID);
            }
        }
        RecipesEventsManager.get().resetRecipes();
        File recipesFolder = new File(OraxenPlugin.get().getDataFolder(), "recipes");
        if (!recipesFolder.exists()) {
            recipesFolder.mkdirs();
            if (Settings.GENERATE_DEFAULT_CONFIGS.toBool().booleanValue()) {
                new ResourcesManager(OraxenPlugin.get()).extractConfigsInFolder("recipes", "yml");
            }
        }
        RecipesManager.registerAllConfigRecipesFromFolder(recipesFolder);
        RecipesEventsManager.get().registerEvents();
    }

    private static void registerAllConfigRecipesFromFolder(File recipesFolder) {
        for (File configFile : Objects.requireNonNull(recipesFolder.listFiles())) {
            RecipesManager.registerConfigRecipes(configFile);
        }
    }

    private static void registerConfigRecipes(File configFile) {
        YamlConfiguration config = OraxenYaml.loadConfiguration(configFile);
        for (String recipeSetting : config.getKeys(false)) {
            if (!config.isConfigurationSection(recipeSetting)) continue;
            ConfigurationSection recipeSection = config.getConfigurationSection(recipeSetting);
            RecipesManager.registerRecipeByType(configFile, recipeSection);
        }
    }

    private static void registerRecipeByType(File configFile, ConfigurationSection recipeSection) {
        try {
            switch (configFile.getName()) {
                case "shaped.yml": {
                    new ShapedLoader(recipeSection).registerRecipe();
                    break;
                }
                case "shapeless.yml": {
                    new ShapelessLoader(recipeSection).registerRecipe();
                    break;
                }
                case "furnace.yml": {
                    new FurnaceLoader(recipeSection).registerRecipe();
                    break;
                }
                case "blasting.yml": {
                    new BlastingLoader(recipeSection).registerRecipe();
                    break;
                }
                case "campfire.yml": {
                    new CampfireLoader(recipeSection).registerRecipe();
                    break;
                }
                case "smoking.yml": {
                    new SmokingLoader(recipeSection).registerRecipe();
                    break;
                }
                case "stonecutting.yml": {
                    new StonecuttingLoader(recipeSection).registerRecipe();
                    break;
                }
                default: {
                    Logs.logError(configFile.getName());
                    break;
                }
            }
        }
        catch (NullPointerException exception) {
            Message.BAD_RECIPE.log(AdventureUtils.tagResolver("recipe", recipeSection.getName()));
        }
    }
}

