/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes;

import io.th0rgal.oraxen.api.OraxenItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class CustomRecipe {
    private final String name;
    private final ItemStack result;
    private final List<ItemStack> ingredients;
    private boolean ordered;

    public CustomRecipe(String name, ItemStack result, List<ItemStack> ingredients) {
        this.name = name;
        this.result = result;
        this.ingredients = ingredients;
    }

    public CustomRecipe(String name, ItemStack result, List<ItemStack> ingredients, boolean ordered) {
        this.name = name;
        this.result = result;
        this.ingredients = ingredients;
        this.ordered = ordered;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStack> getIngredients() {
        return !this.ingredients.isEmpty() ? this.ingredients : new ArrayList<ItemStack>();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CustomRecipe) {
            CustomRecipe customRecipe = (CustomRecipe)object;
            return this.result.equals((Object)customRecipe.result) && this.areEqual(this.ingredients, customRecipe.ingredients);
        }
        return false;
    }

    public int hashCode() {
        return this.result.hashCode() / 2 + this.ingredients.hashCode() / 2 + (this.ordered ? 1 : 0);
    }

    private boolean areEqual(List<ItemStack> ingredients1, List<ItemStack> ingredients2) {
        if (ingredients1.size() != ingredients2.size()) {
            return false;
        }
        for (int index = 0; index < ingredients1.size(); ++index) {
            ItemStack ingredient1 = ingredients1.get(index);
            if (this.ordered) {
                ItemStack ingredient2 = ingredients2.get(index);
                if (ingredient1 == null && ingredient2 == null) continue;
                if (ingredient1 == null || ingredient2 == null) {
                    return false;
                }
                if (ingredient1.isSimilar(ingredient2)) continue;
                return false;
            }
            if (ingredient1 == null || !ingredients2.stream().noneMatch(arg_0 -> ((ItemStack)ingredient1).isSimilar(arg_0))) continue;
            return false;
        }
        return true;
    }

    public static CustomRecipe fromRecipe(Recipe bukkitRecipe) {
        if (bukkitRecipe instanceof ShapedRecipe) {
            ShapedRecipe recipe = (ShapedRecipe)bukkitRecipe;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(9);
            Map map = recipe.getIngredientMap();
            for (String row : recipe.getShape()) {
                char[] chars = row.toCharArray();
                for (int charIndex = 0; charIndex < 3; ++charIndex) {
                    if (charIndex >= chars.length) {
                        ingredients.add(null);
                        continue;
                    }
                    ingredients.add((ItemStack)map.get(Character.valueOf(chars[charIndex])));
                }
            }
            return new CustomRecipe(recipe.getKey().getKey(), recipe.getResult(), ingredients, true);
        }
        if (bukkitRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe recipe = (ShapelessRecipe)bukkitRecipe;
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(9);
            ingredients.addAll(recipe.getIngredientList());
            return new CustomRecipe(recipe.getKey().getKey(), recipe.getResult(), ingredients, false);
        }
        return null;
    }

    public boolean isValidDyeRecipe() {
        if (!this.isDyeRecipe()) {
            return false;
        }
        List<ItemStack> items = this.ingredients.stream().filter(i -> i != null && !i.getType().toString().endsWith("_DYE")).toList();
        if (items.size() != 1) {
            return false;
        }
        ItemStack item = items.get(0);
        if (item == null) {
            return false;
        }
        return !OraxenItems.exists(item) || !item.hasItemMeta() || !(item.getItemMeta() instanceof LeatherArmorMeta) || item.getType() == Material.LEATHER_HORSE_ARMOR;
    }

    private boolean isDyeRecipe() {
        return this.ingredients.stream().filter(Objects::nonNull).toList().size() == 2 && this.ingredients.stream().anyMatch(item -> item != null && item.getType().toString().endsWith("_DYE"));
    }
}

