/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class PredicatesGenerator {
    private final JsonObject json = new JsonObject();
    private final String[] tools = new String[]{"PICKAXE", "SWORD", "HOE", "AXE", "SHOVEL"};

    public PredicatesGenerator(Material material, List<ItemBuilder> items) {
        this.json.addProperty("parent", this.getParent(material));
        String vanillaTextureName = this.getVanillaTextureName(material, false);
        ItemMeta exampleMeta = new ItemStack(material).getItemMeta();
        JsonObject textures = new JsonObject();
        if (exampleMeta instanceof PotionMeta) {
            textures.addProperty("layer0", vanillaTextureName + "_overlay");
            textures.addProperty("layer1", vanillaTextureName);
        } else if (exampleMeta instanceof LeatherArmorMeta && material != Material.LEATHER_HORSE_ARMOR) {
            textures.addProperty("layer0", vanillaTextureName);
            textures.addProperty("layer1", vanillaTextureName + "_overlay");
        } else {
            textures.addProperty("layer0", vanillaTextureName);
        }
        this.json.add("textures", (JsonElement)textures);
        JsonArray overrides = new JsonArray();
        switch (material) {
            case SHIELD: {
                overrides.add((JsonElement)this.getOverride("blocking", 1, "item/shield_blocking"));
                this.json.addProperty("gui_light", "front");
                this.json.add("display", (JsonElement)JsonParser.parseString((String)Settings.SHIELD_DISPLAY.toString()).getAsJsonObject());
                break;
            }
            case BOW: {
                JsonObject pullingPredicate = new JsonObject();
                pullingPredicate.addProperty("pulling", (Number)1);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)pullingPredicate.toString()).getAsJsonObject(), "item/bow_pulling_0"));
                pullingPredicate.addProperty("pull", (Number)0.65);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)pullingPredicate.toString()).getAsJsonObject(), "item/bow_pulling_1"));
                pullingPredicate.addProperty("pull", (Number)0.9);
                overrides.add((JsonElement)this.getOverride(pullingPredicate, "item/bow_pulling_2"));
                this.json.add("display", (JsonElement)JsonParser.parseString((String)Settings.BOW_DISPLAY.toString()).getAsJsonObject());
                break;
            }
            case CROSSBOW: {
                JsonObject pullingPredicate = new JsonObject();
                pullingPredicate.addProperty("pulling", (Number)1);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)pullingPredicate.toString()).getAsJsonObject(), "item/crossbow_pulling_0"));
                pullingPredicate.addProperty("pull", (Number)0.65);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)pullingPredicate.toString()).getAsJsonObject(), "item/crossbow_pulling_1"));
                pullingPredicate.addProperty("pull", (Number)0.9);
                overrides.add((JsonElement)this.getOverride(pullingPredicate, "item/crossbow_pulling_2"));
                JsonObject chargedPredicate = new JsonObject();
                chargedPredicate.addProperty("charged", (Number)1);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)chargedPredicate.toString()).getAsJsonObject(), "item/crossbow_arrow"));
                chargedPredicate.addProperty("firework", (Number)1);
                overrides.add((JsonElement)this.getOverride(JsonParser.parseString((String)chargedPredicate.toString()).getAsJsonObject(), "item/crossbow_firework"));
                this.json.add("display", (JsonElement)JsonParser.parseString((String)Settings.CROSSBOW_DISPLAY.toString()).getAsJsonObject());
            }
        }
        for (ItemBuilder item : items) {
            JsonObject predicate;
            int i;
            JsonObject predicate2;
            OraxenMeta oraxenMeta = item.getOraxenMeta();
            int customModelData = oraxenMeta.getCustomModelData();
            if (overrides.contains((JsonElement)this.getOverride("custom_model_data", customModelData, oraxenMeta.getGeneratedModelPath() + oraxenMeta.getModelName()))) continue;
            overrides.add((JsonElement)this.getOverride("custom_model_data", customModelData, oraxenMeta.getGeneratedModelPath() + oraxenMeta.getModelName()));
            if (oraxenMeta.hasBlockingModel()) {
                predicate2 = new JsonObject();
                predicate2.addProperty("blocking", (Number)1);
                overrides.add((JsonElement)this.getOverride(predicate2, "custom_model_data", customModelData, oraxenMeta.getBlockingModel()));
            }
            if (oraxenMeta.hasChargedModel()) {
                predicate2 = new JsonObject();
                predicate2.addProperty("charged", (Number)1);
                overrides.add((JsonElement)this.getOverride(predicate2, "custom_model_data", customModelData, oraxenMeta.getChargedModel()));
            }
            if (oraxenMeta.hasFireworkModel()) {
                predicate2 = new JsonObject();
                predicate2.addProperty("charged", (Number)1);
                predicate2.addProperty("firework", (Number)1);
                overrides.add((JsonElement)this.getOverride(predicate2, "custom_model_data", customModelData, oraxenMeta.getFireworkModel()));
            }
            if (oraxenMeta.hasPullingModels()) {
                List<String> pullingModels = oraxenMeta.getPullingModels();
                for (i = 0; i <= pullingModels.size(); ++i) {
                    if (i == 0) continue;
                    predicate = new JsonObject();
                    predicate.addProperty("pulling", (Number)1);
                    predicate.addProperty("pull", (Number)Float.valueOf(Math.min((float)i / (float)pullingModels.size(), 0.99f)));
                    overrides.add((JsonElement)this.getOverride(predicate, "custom_model_data", customModelData, pullingModels.get(i - 1)));
                }
            }
            if (oraxenMeta.hasCastModel()) {
                predicate2 = new JsonObject();
                predicate2.addProperty("cast", (Number)1);
                overrides.add((JsonElement)this.getOverride(predicate2, "custom_model_data", customModelData, oraxenMeta.getCastModel()));
            }
            if (!oraxenMeta.hasDamagedModels()) continue;
            List<String> damagedModels = oraxenMeta.getDamagedModels();
            for (i = 0; i <= damagedModels.size(); ++i) {
                if (i == 0) continue;
                predicate = new JsonObject();
                predicate.addProperty("damaged", (Number)1);
                predicate.addProperty("damage", (Number)Float.valueOf(Math.min((float)i / (float)damagedModels.size(), 0.99f)));
                overrides.add((JsonElement)this.getOverride(predicate, "custom_model_data", customModelData, damagedModels.get(i - 1)));
            }
        }
        this.json.add("overrides", (JsonElement)overrides);
    }

    public static void generatePullingModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasPullingTextures()) {
            return;
        }
        for (String texture : oraxenMeta.getPullingTextures()) {
            JsonObject json = new JsonObject();
            json.addProperty("parent", oraxenMeta.getParentModel());
            JsonObject textureJson = new JsonObject();
            textureJson.addProperty("layer0", texture);
            json.add("textures", (JsonElement)textureJson);
            ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(texture)), Utils.getFileNameOnly(texture) + ".json", json.toString());
        }
    }

    public static void generateChargedModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasChargedTexture()) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("parent", oraxenMeta.getParentModel());
        JsonObject textureJson = new JsonObject();
        textureJson.addProperty("layer0", oraxenMeta.getChargedTexture());
        json.add("textures", (JsonElement)textureJson);
        ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(oraxenMeta.getChargedTexture())), Utils.getFileNameOnly(oraxenMeta.getChargedTexture()) + ".json", json.toString());
    }

    public static void generateBlockingModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasBlockingTexture()) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("parent", oraxenMeta.getParentModel());
        JsonObject textureJson = new JsonObject();
        textureJson.addProperty("layer0", oraxenMeta.getBlockingTexture());
        json.add("textures", (JsonElement)textureJson);
        ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(oraxenMeta.getBlockingTexture())), Utils.getFileNameOnly(oraxenMeta.getBlockingTexture()) + ".json", json.toString());
    }

    public static void generateFireworkModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasFireworkTexture()) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("parent", oraxenMeta.getParentModel());
        JsonObject textureJson = new JsonObject();
        textureJson.addProperty("layer0", oraxenMeta.getFireworkTexture());
        json.add("textures", (JsonElement)textureJson);
        ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(oraxenMeta.getFireworkTexture())), Utils.getFileNameOnly(oraxenMeta.getFireworkTexture()) + ".json", json.toString());
    }

    public static void generateCastModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasCastTexture()) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("parent", oraxenMeta.getParentModel());
        JsonObject textureJson = new JsonObject();
        textureJson.addProperty("layer0", oraxenMeta.getCastTexture());
        json.add("textures", (JsonElement)textureJson);
        ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(oraxenMeta.getCastTexture())), Utils.getFileNameOnly(oraxenMeta.getCastTexture()) + ".json", json.toString());
    }

    public static void generateDamageModels(OraxenMeta oraxenMeta) {
        if (!oraxenMeta.hasDamagedTextures()) {
            return;
        }
        for (String texture : oraxenMeta.getDamagedTextures()) {
            JsonObject json = new JsonObject();
            json.addProperty("parent", oraxenMeta.getParentModel());
            JsonObject textureJson = new JsonObject();
            textureJson.addProperty("layer0", texture);
            json.add("textures", (JsonElement)textureJson);
            ResourcePack.writeStringToVirtual(OraxenMeta.getModelPath(Utils.getParentDirs(texture)), Utils.getFileNameOnly(texture) + ".json", json.toString());
        }
    }

    private JsonObject getOverride(String property, int propertyValue, String model) {
        return this.getOverride(new JsonObject(), property, propertyValue, model);
    }

    private JsonObject getOverride(JsonObject predicate, String property, int propertyValue, String model) {
        predicate.addProperty(property, (Number)propertyValue);
        return this.getOverride(predicate, model);
    }

    private JsonObject getOverride(JsonObject predicate, String model) {
        JsonObject override = new JsonObject();
        override.add("predicate", (JsonElement)predicate);
        override.addProperty("model", model);
        return override;
    }

    public String getVanillaModelName(Material material) {
        return this.getVanillaTextureName(material, true);
    }

    public String getVanillaTextureName(Material material, boolean model) {
        if (!model) {
            if (material.isBlock()) {
                return "block/" + material.toString().toLowerCase(Locale.ENGLISH);
            }
            if (material == Material.CROSSBOW) {
                return "item/crossbow_standby";
            }
        }
        return "item/" + material.toString().toLowerCase(Locale.ENGLISH);
    }

    private String getParent(Material material) {
        if (material.isBlock()) {
            return "block/cube_all";
        }
        if (Arrays.stream(this.tools).anyMatch(tool -> material.toString().contains((CharSequence)tool))) {
            return "item/handheld";
        }
        if (material == Material.FISHING_ROD) {
            return "item/handheld_rod";
        }
        if (material == Material.SHIELD) {
            return "builtin/entity";
        }
        return "item/generated";
    }

    public JsonObject toJSON() {
        return this.json;
    }
}

