/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.dispatch;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.dispatch.PackSender;
import io.th0rgal.oraxen.pack.upload.hosts.HostingProvider;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class BukkitPackSender
extends PackSender
implements Listener {
    private static final String prompt = Settings.SEND_PACK_PROMPT.toString();
    private static final boolean mandatory = Settings.SEND_PACK_MANDATORY.toBool();

    public BukkitPackSender(HostingProvider hostingProvider) {
        super(hostingProvider);
    }

    @Override
    public void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)OraxenPlugin.get());
    }

    @Override
    public void unregister() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void sendPack(Player player) {
        if (VersionUtil.isPaperServer()) {
            player.setResourcePack(this.hostingProvider.getMinecraftPackURL(), this.hostingProvider.getSHA1(), AdventureUtils.MINI_MESSAGE.deserialize((Object)prompt), mandatory);
        } else {
            player.setResourcePack(this.hostingProvider.getMinecraftPackURL(), this.hostingProvider.getSHA1(), (Component)AdventureUtils.LEGACY_SERIALIZER.deserialize(prompt), mandatory);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerConnect(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (Settings.SEND_JOIN_MESSAGE.toBool().booleanValue()) {
            this.sendWelcomeMessage(player, true);
        }
        if (!Settings.SEND_PACK.toBool().booleanValue()) {
            return;
        }
        int delay = (Integer)Settings.SEND_PACK_DELAY.getValue();
        if (delay <= 0) {
            this.sendPack(player);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)OraxenPlugin.get(), () -> this.sendPack(player), (long)delay * 20L);
        }
    }
}

