/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.food;

import io.lumine.mythiccrucible.MythicCrucible;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FoodMechanic
extends Mechanic {
    private final Set<PotionEffect> effects = new HashSet<PotionEffect>();
    private final double effectProbability;
    private final int hunger;
    private final int saturation;
    private ItemStack replacementItem;

    public FoodMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.hunger = section.getInt("hunger");
        this.saturation = section.getInt("saturation");
        this.effectProbability = Math.min(section.getDouble("effect_probability", 1.0), 1.0);
        if (section.isConfigurationSection("replacement")) {
            ConfigurationSection replacementSection = section.getConfigurationSection("replacement");
            assert (replacementSection != null);
            this.registerReplacement(replacementSection);
        } else {
            this.replacementItem = null;
        }
        if (section.isConfigurationSection("effects")) {
            ConfigurationSection effectsSection = section.getConfigurationSection("effects");
            assert (effectsSection != null);
            for (String effectSection : effectsSection.getKeys(false)) {
                if (!section.isConfigurationSection(effectSection)) continue;
                ConfigurationSection effect = section.getConfigurationSection("effectSection");
                assert (effect != null);
                this.registerEffects(effect);
            }
        }
    }

    private void registerEffects(ConfigurationSection section) {
        PotionEffectType effectType = PotionEffectType.getByName((String)section.getName());
        if (effectType == null) {
            Logs.logError("Invalid effect type: " + section.getName() + " in " + this.getItemID());
            return;
        }
        this.effects.add(new PotionEffect(effectType, section.getInt("duration", 1) * 20, section.getInt("amplifier", 0), section.getBoolean("is_ambient", true), section.getBoolean("has_particles", true), section.getBoolean("has_icon", true)));
    }

    private void registerReplacement(ConfigurationSection section) {
        if (section.isString("minecraft_type")) {
            Material material = Material.getMaterial((String)Objects.requireNonNull(section.getString("minecraft_type")));
            if (material == null) {
                Logs.logError("Invalid material: " + section.getString("minecraft_type"));
                this.replacementItem = null;
            } else {
                this.replacementItem = new ItemStack(material);
            }
        } else {
            this.replacementItem = section.isString("oraxen_item") ? OraxenItems.getItemById(section.getString("oraxen_item")).build() : (section.isString("crucible_item") ? MythicCrucible.core().getItemManager().getItemStack(section.getString("crucible_item")) : (section.isString("mmoitems_id") && section.isString("mmoitems_type") ? MMOItems.plugin.getItem(section.getString("mmoitems_type"), section.getString("mmoitems_id")) : null));
        }
    }

    public int getHunger() {
        return this.hunger;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public boolean hasReplacement() {
        return this.replacementItem != null;
    }

    public ItemStack getReplacement() {
        return this.replacementItem;
    }

    public boolean hasEffects() {
        return !this.effects.isEmpty();
    }

    public Set<PotionEffect> getEffects() {
        return this.effects;
    }

    public double getEffectProbability() {
        return this.effectProbability;
    }
}

