/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockInteractEvent;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockPlaceEvent;
import io.th0rgal.oraxen.compatibilities.provided.lightapi.WrappedLightAPI;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import io.th0rgal.oraxen.utils.breaker.HardnessModifier;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class StringBlockMechanicListener
implements Listener {
    private final MechanicFactory factory;

    public StringBlockMechanicListener(StringBlockMechanicFactory factory) {
        this.factory = factory;
        BreakerSystem.MODIFIERS.add(this.getHardnessModifier());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void callInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.NOTE_BLOCK) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (!new OraxenStringBlockInteractEvent(mechanic, event.getPlayer(), event.getItem(), event.getHand(), block, event.getBlockFace()).callEvent()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlacingString(PlayerInteractEvent event) {
        if (event.getItem() == null || event.getItem().getType() != Material.STRING) {
            return;
        }
        if (StringBlockMechanicFactory.getInstance().disableVanillaString) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlacingString(BlockPlaceEvent event) {
        Block placedBlock = event.getBlockPlaced();
        if (placedBlock.getType() != Material.TRIPWIRE || OraxenItems.exists(event.getItemInHand())) {
            return;
        }
        placedBlock.setBlockData(Material.TRIPWIRE.createBlockData(), false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLimitedPlacing(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace blockFace = event.getBlockFace();
        ItemStack item = event.getItem();
        if (item == null || block == null || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(OraxenItems.getIdByItem(item));
        if (mechanic == null || !mechanic.hasLimitedPlacing()) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(block)) {
            return;
        }
        LimitedPlacing limitedPlacing = mechanic.getLimitedPlacing();
        Block belowPlaced = block.getRelative(blockFace).getRelative(BlockFace.DOWN);
        if (limitedPlacing.isNotPlacableOn(block, blockFace)) {
            event.setCancelled(true);
        } else if (limitedPlacing.isRadiusLimited()) {
            LimitedPlacing.RadiusLimitation radiusLimitation = limitedPlacing.getRadiusLimitation();
            int rad = radiusLimitation.getRadius();
            int amount = radiusLimitation.getAmount();
            int count = 0;
            for (int x = -rad; x <= rad; ++x) {
                for (int y = -rad; y <= rad; ++y) {
                    for (int z = -rad; z <= rad; ++z) {
                        StringBlockMechanic relativeMechanic = OraxenBlocks.getStringMechanic(block.getRelative(x, y, z));
                        if (relativeMechanic == null || !relativeMechanic.getItemID().equals(mechanic.getItemID())) continue;
                        ++count;
                    }
                }
            }
            if (count >= amount) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.ALLOW) {
            if (!limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.DENY && limitedPlacing.checkLimitedMechanic(belowPlaced)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPrePlacingCustomBlock(PlayerInteractEvent event) {
        Block placedBlock;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        Block placedAgainst = event.getClickedBlock();
        Player player = event.getPlayer();
        StringBlockMechanic mechanic = (StringBlockMechanic)this.factory.getMechanic(itemID);
        if (mechanic == null || placedAgainst == null) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(placedAgainst)) {
            return;
        }
        if (item != null && item.getType().isBlock() && !this.factory.isNotImplementedIn(itemID)) {
            for (BlockFace face : BlockFace.values()) {
                Block relative;
                if (!face.isCartesian() || face.getModZ() != 0 || OraxenBlocks.getNoteBlockMechanic(relative = placedAgainst.getRelative(face)) == null || OraxenBlocks.getStringMechanic(relative) == null || item.getItemMeta() instanceof BlockStateMeta || item.getType().hasGravity() || item.getType().toString().endsWith("SLAB")) continue;
                this.makePlayerPlaceBlock(player, event.getHand(), item, placedAgainst, event.getBlockFace(), Bukkit.createBlockData((Material)item.getType()));
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> StringBlockMechanicListener.fixClientsideUpdate(placedAgainst.getLocation()), 1L);
            }
        }
        int customVariation = mechanic.getCustomVariation();
        if (mechanic.hasRandomPlace()) {
            List<String> randomList = mechanic.getRandomPlaceBlock();
            String randomBlock = randomList.get(new Random().nextInt(randomList.size()));
            customVariation = ((StringBlockMechanic)this.factory.getMechanic(randomBlock)).getCustomVariation();
        }
        if ((placedBlock = this.makePlayerPlaceBlock(player, event.getHand(), event.getItem(), placedAgainst, event.getBlockFace(), StringBlockMechanicFactory.createTripwireData(customVariation))) == null) {
            return;
        }
        if (mechanic.getLight() != -1) {
            WrappedLightAPI.createBlockLight(placedBlock.getLocation(), mechanic.getLight());
        }
        if (mechanic.isSapling()) {
            SaplingMechanic sapling = mechanic.getSaplingMechanic();
            if (mechanic.getSaplingMechanic().canGrowNaturally()) {
                BlockHelpers.getPDC(placedBlock).set(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER, (Object)sapling.getNaturalGrowthTime());
            }
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        EquipmentSlot hand = event.getHand();
        if (hand == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (block == null || block.getType() != Material.TRIPWIRE) {
            return;
        }
        StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic(block);
        if (stringBlockMechanic == null) {
            return;
        }
        if (!new OraxenStringBlockInteractEvent(stringBlockMechanic, event.getPlayer(), event.getItem(), event.getHand(), block, event.getBlockFace()).callEvent()) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakingCustomBlock(BlockBreakEvent event) {
        Block block = event.getBlock();
        Block blockAbove = block.getRelative(BlockFace.UP);
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        Player player = event.getPlayer();
        if (block.getType() == Material.TRIPWIRE) {
            StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(blockBelow);
            if (OraxenBlocks.isOraxenStringBlock(block)) {
                event.setCancelled(true);
                OraxenBlocks.remove(block.getLocation(), player);
                event.setDropItems(false);
            } else if (mechanicBelow != null && mechanicBelow.isTall()) {
                event.setCancelled(true);
                OraxenBlocks.remove(blockBelow.getLocation(), player);
                event.setDropItems(false);
            }
        } else if (blockAbove.getType() == Material.TRIPWIRE) {
            if (!OraxenBlocks.isOraxenStringBlock(blockAbove)) {
                return;
            }
            event.setCancelled(true);
            OraxenBlocks.remove(blockAbove.getLocation(), player);
            block.setType(Material.AIR);
            event.setDropItems(false);
        }
    }

    @EventHandler
    public void onExplosionDestroy(EntityExplodeEvent event) {
        List<Block> blockList = event.blockList().stream().filter(block -> block.getType().equals((Object)Material.TRIPWIRE)).toList();
        blockList.forEach(block -> {
            StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic(block);
            if (stringBlockMechanic == null) {
                return;
            }
            Block blockAbove = block.getRelative(BlockFace.UP);
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            if (block.getType() == Material.TRIPWIRE) {
                StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(blockBelow);
                if (OraxenBlocks.isOraxenStringBlock(block)) {
                    event.setCancelled(true);
                    OraxenBlocks.remove(block.getLocation(), null);
                } else if (mechanicBelow != null && mechanicBelow.isTall()) {
                    event.setCancelled(true);
                    OraxenBlocks.remove(blockBelow.getLocation(), null);
                }
            } else if (blockAbove.getType() == Material.TRIPWIRE) {
                if (!OraxenBlocks.isOraxenStringBlock(blockAbove)) {
                    return;
                }
                event.setCancelled(true);
                OraxenBlocks.remove(blockAbove.getLocation(), null);
                block.setType(Material.AIR);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWaterUpdate(BlockFromToEvent event) {
        if (!event.getBlock().isLiquid()) {
            return;
        }
        for (BlockFace f : BlockFace.values()) {
            if (!f.isCartesian() || f == BlockFace.SELF) continue;
            Block changed = event.getToBlock().getRelative(f);
            Block changedBelow = changed.getRelative(BlockFace.DOWN);
            if (changed.getType() != Material.TRIPWIRE) continue;
            StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(changedBelow);
            if (OraxenBlocks.isOraxenStringBlock(changed)) {
                OraxenBlocks.remove(changed.getLocation(), null);
                continue;
            }
            if (mechanicBelow == null || !mechanicBelow.isTall()) continue;
            OraxenBlocks.remove(changedBelow.getLocation(), null);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMiddleClick(InventoryCreativeEvent event) {
        if (event.getClick() != ClickType.CREATIVE) {
            return;
        }
        Player player = (Player)event.getInventory().getHolder();
        if (player == null) {
            return;
        }
        if (event.getCursor().getType() == Material.STRING) {
            RayTraceResult rayTraceResult = player.rayTraceBlocks(6.0);
            if (rayTraceResult == null) {
                return;
            }
            Block block = rayTraceResult.getHitBlock();
            if (block == null) {
                return;
            }
            StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
            if (mechanic == null) {
                StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(block.getRelative(BlockFace.DOWN));
                if (mechanicBelow == null || !mechanicBelow.isTall()) {
                    return;
                }
                mechanic = mechanicBelow;
            }
            ItemStack item = OraxenItems.getItemById(mechanic.getItemID()).build();
            for (int i = 0; i <= 8; ++i) {
                if (player.getInventory().getItem(i) == null || !Objects.equals(OraxenItems.getIdByItem(player.getInventory().getItem(i)), mechanic.getItemID())) continue;
                player.getInventory().setHeldItemSlot(i);
                event.setCancelled(true);
                return;
            }
            event.setCursor(item);
        }
    }

    private HardnessModifier getHardnessModifier() {
        return new HardnessModifier(){

            @Override
            public boolean isTriggered(Player player, Block block, ItemStack tool) {
                if (block.getType() != Material.TRIPWIRE) {
                    return false;
                }
                StringBlockMechanic tripwireMechanic = OraxenBlocks.getStringMechanic(block);
                return tripwireMechanic != null && tripwireMechanic.hasHardness();
            }

            @Override
            public void breakBlock(Player player, Block block, ItemStack tool) {
                block.setType(Material.AIR);
            }

            @Override
            public long getPeriod(Player player, Block block, ItemStack tool) {
                StringBlockMechanic tripwireMechanic = OraxenBlocks.getStringMechanic(block);
                if (tripwireMechanic == null) {
                    return 0L;
                }
                long period = tripwireMechanic.getHardness();
                double modifier = 1.0;
                if (tripwireMechanic.getDrop().canDrop(tool)) {
                    modifier *= 0.4;
                    int diff = tripwireMechanic.getDrop().getDiff(tool);
                    if (diff >= 1) {
                        modifier *= Math.pow(0.9, diff);
                    }
                }
                return (long)((double)period * modifier);
            }
        };
    }

    private Block makePlayerPlaceBlock(Player player, EquipmentSlot hand, ItemStack item, Block placedAgainst, BlockFace face, BlockData newData) {
        Block target;
        Material type = placedAgainst.getType();
        if (BlockHelpers.isReplaceable(type)) {
            target = placedAgainst;
        } else {
            target = placedAgainst.getRelative(face);
            if (!target.getType().isAir() && target.getType() != Material.WATER && target.getType() != Material.LAVA) {
                return null;
            }
        }
        if (BlockHelpers.isStandingInside(player, target) || !ProtectionLib.canBuild((Player)player, (Location)target.getLocation())) {
            return null;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(newData);
        if (mechanic == null) {
            return null;
        }
        BlockPlaceEvent blockPlaceEvent = new BlockPlaceEvent(target, target.getState(), placedAgainst, item, player, true, hand);
        OraxenStringBlockPlaceEvent oraxenBlockPlaceEvent = new OraxenStringBlockPlaceEvent(mechanic, target, player, item, hand);
        Block blockAbove = target.getRelative(BlockFace.UP);
        if (mechanic.isTall()) {
            if (!BlockHelpers.REPLACEABLE_BLOCKS.contains(blockAbove.getType())) {
                blockPlaceEvent.setCancelled(true);
                oraxenBlockPlaceEvent.setCancelled(true);
            } else {
                blockAbove.setType(Material.TRIPWIRE);
            }
        }
        if (player.getGameMode() == GameMode.ADVENTURE) {
            blockPlaceEvent.setCancelled(true);
        }
        if (!(blockPlaceEvent.callEvent() && blockPlaceEvent.canBuild() && oraxenBlockPlaceEvent.callEvent())) {
            return null;
        }
        Object sound = newData.getMaterial() == Material.WATER || newData.getMaterial() == Material.LAVA ? (newData.getMaterial() == Material.WATER ? "item.bucket.empty" : "item.bucket.empty_" + newData.getMaterial().toString().toLowerCase()) : (!OraxenBlocks.isOraxenBlock(target) ? target.getBlockData().getSoundGroup().getPlaceSound().getKey().toString() : null);
        if (sound != null) {
            BlockHelpers.playCustomBlockSound(target.getLocation(), (String)sound, SoundCategory.BLOCKS, 0.8f, 0.8f);
        }
        return BlockHelpers.correctAllBlockStates(placedAgainst, player, hand, face, item, newData) != null ? target : null;
    }

    public static void fixClientsideUpdate(Location loc) {
        List<Entity> players = Objects.requireNonNull(loc.getWorld()).getNearbyEntities(loc, 20.0, 20.0, 20.0).stream().filter(entity -> entity.getType() == EntityType.PLAYER).toList();
        for (double x = loc.getX() - 10.0; x < loc.getX() + 10.0; x += 1.0) {
            for (double y = loc.getY() - 4.0; y < loc.getY() + 4.0; y += 1.0) {
                for (double z = loc.getZ() - 10.0; z < loc.getZ() + 10.0; z += 1.0) {
                    if (loc.getBlock().getType() != Material.TRIPWIRE) continue;
                    Location newLoc = new Location(loc.getWorld(), x, y, z);
                    for (Entity e : players) {
                        ((Player)e).sendBlockChange(newLoc, newLoc.getBlock().getBlockData());
                    }
                }
            }
        }
    }

    public static class StringBlockMechanicPhysicsListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void tripwireEvent(BlockPhysicsEvent event) {
            Block block = event.getBlock();
            if (event.getChangedType() != Material.TRIPWIRE) {
                return;
            }
            if (event.getSourceBlock() == event.getBlock()) {
                return;
            }
            event.setCancelled(true);
            for (BlockFace f : BlockFace.values()) {
                Block changed;
                if (!f.isCartesian() || f.getModY() != 0 || f == BlockFace.SELF || (changed = block.getRelative(f)).getType() != Material.TRIPWIRE) continue;
                BlockData data = changed.getBlockData().clone();
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> changed.setBlockData(data, false), 1L);
            }
            BlockData blockData = block.getBlockData().clone();
            Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> {
                if (block.getType().isAir()) {
                    return;
                }
                block.setBlockData(blockData, false);
            }, 1L);
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPistonPush(BlockPistonExtendEvent event) {
            List<Block> tripwireList = event.getBlocks().stream().filter(block -> block.getType().equals((Object)Material.TRIPWIRE)).toList();
            for (Block block2 : tripwireList) {
                StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block2);
                if (mechanic == null) {
                    return;
                }
                block2.setType(Material.AIR, false);
                if (mechanic.hasLight()) {
                    WrappedLightAPI.removeBlockLight(block2.getLocation());
                }
                mechanic.getDrop().spawns(block2.getLocation(), new ItemStack(Material.AIR));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onEnteringTripwire(EntityInsideBlockEvent event) {
            if (event.getBlock().getType() == Material.TRIPWIRE) {
                event.setCancelled(true);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onBreak(BlockBreakEvent event) {
            Block block = event.getBlock();
            Block blockAbove = block.getRelative(BlockFace.UP);
            Player player = event.getPlayer();
            for (BlockFace face : BlockFace.values()) {
                if (face == BlockFace.SELF && !face.isCartesian()) continue;
                if (block.getType() == Material.TRIPWIRE || block.getType() == Material.NOTE_BLOCK || block.getType() == Material.BARRIER && OraxenFurniture.isFurniture(block)) break;
                if (block.getRelative(face).getType() != Material.TRIPWIRE) continue;
                if (player.getGameMode() != GameMode.CREATIVE) {
                    block.breakNaturally(player.getInventory().getItemInMainHand(), true);
                } else {
                    block.setType(Material.AIR);
                }
                if (BlockHelpers.isReplaceable(blockAbove.getType())) {
                    blockAbove.breakNaturally(true);
                }
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> StringBlockMechanicListener.fixClientsideUpdate(block.getLocation()), 1L);
            }
        }
    }
}

