/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.directional;

import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import org.apache.commons.lang3.Range;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class DirectionalBlock {
    private final String parentBlock;
    private final DirectionalType directionalType;
    private final String yBlock;
    private final String xBlock;
    private final String zBlock;
    private final String northBlock;
    private final String southBlock;
    private final String eastBlock;
    private final String westBlock;
    private final String upBlock;
    private final String downBlock;

    public DirectionalBlock(ConfigurationSection directionalSection) {
        this.parentBlock = directionalSection.getString("parent_block");
        this.directionalType = DirectionalType.valueOf(directionalSection.getString("directional_type", "LOG"));
        this.yBlock = directionalSection.getString("y_block");
        this.xBlock = directionalSection.getString("x_block");
        this.zBlock = directionalSection.getString("z_block");
        this.northBlock = directionalSection.getString("north_block");
        this.southBlock = directionalSection.getString("south_block");
        this.eastBlock = directionalSection.getString("east_block");
        this.westBlock = directionalSection.getString("west_block");
        this.upBlock = directionalSection.getString("up_block");
        this.downBlock = directionalSection.getString("down_block");
    }

    public boolean isParentBlock() {
        return this.parentBlock == null;
    }

    public String getParentBlock() {
        return this.parentBlock;
    }

    public NoteBlockMechanic getParentMechanic() {
        if (this.parentBlock == null) {
            return null;
        }
        return (NoteBlockMechanic)NoteBlockMechanicFactory.getInstance().getMechanic(this.parentBlock);
    }

    public DirectionalType getDirectionalType() {
        return this.directionalType;
    }

    public boolean isLog() {
        return this.directionalType == DirectionalType.LOG;
    }

    public boolean isFurnace() {
        return this.directionalType == DirectionalType.FURNACE;
    }

    public boolean isDropper() {
        return this.directionalType == DirectionalType.DROPPER;
    }

    public String getYBlock() {
        return this.yBlock;
    }

    public String getXBlock() {
        return this.xBlock;
    }

    public String getZBlock() {
        return this.zBlock;
    }

    public String getNorthBlock() {
        return this.northBlock;
    }

    public String getSouthBlock() {
        return this.southBlock;
    }

    public String getEastBlock() {
        return this.eastBlock;
    }

    public String getWestBlock() {
        return this.westBlock;
    }

    public String getUpBlock() {
        return this.upBlock;
    }

    public String getDownBlock() {
        return this.downBlock;
    }

    public int getDirectionVariation(BlockFace face, Player player) {
        if (this.isLog()) {
            switch (face) {
                case NORTH: 
                case SOUTH: {
                    return this.getDirectionVariation(this.xBlock);
                }
                case EAST: 
                case WEST: {
                    return this.getDirectionVariation(this.zBlock);
                }
                case UP: 
                case DOWN: {
                    return this.getDirectionVariation(this.yBlock);
                }
            }
        } else {
            switch (this.getRelativeFacing(player)) {
                case NORTH: {
                    return this.getDirectionVariation(this.northBlock);
                }
                case SOUTH: {
                    return this.getDirectionVariation(this.southBlock);
                }
                case EAST: {
                    return this.getDirectionVariation(this.eastBlock);
                }
                case WEST: {
                    return this.getDirectionVariation(this.westBlock);
                }
                case UP: {
                    return this.getDirectionVariation(this.upBlock);
                }
                case DOWN: {
                    return this.getDirectionVariation(this.downBlock);
                }
            }
        }
        return 0;
    }

    private BlockFace getRelativeFacing(Player player) {
        double yaw = player.getLocation().getYaw();
        double pitch = player.getLocation().getPitch();
        BlockFace face = BlockFace.SELF;
        if (!this.isLog()) {
            if (Range.between((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(45.0)).contains((Object)yaw) || yaw >= 315.0 || yaw >= -45.0 && yaw <= 0.0 || yaw <= -315.0) {
                face = BlockFace.NORTH;
            } else if (Range.between((Comparable)Double.valueOf(45.0), (Comparable)Double.valueOf(135.0)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-315.0), (Comparable)Double.valueOf(-225.0)).contains((Object)yaw)) {
                face = BlockFace.EAST;
            } else if (Range.between((Comparable)Double.valueOf(135.0), (Comparable)Double.valueOf(225.0)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-225.0), (Comparable)Double.valueOf(-135.0)).contains((Object)yaw)) {
                face = BlockFace.SOUTH;
            } else if (Range.between((Comparable)Double.valueOf(225.0), (Comparable)Double.valueOf(315.0)).contains((Object)yaw) || Range.between((Comparable)Double.valueOf(-135.0), (Comparable)Double.valueOf(-45.0)).contains((Object)yaw)) {
                face = BlockFace.WEST;
            }
            if (this.isDropper()) {
                face = pitch <= -45.0 ? BlockFace.DOWN : (pitch >= 45.0 ? BlockFace.UP : face);
            }
        }
        return face;
    }

    private int getDirectionVariation(String id) {
        return ((NoteBlockMechanic)NoteBlockMechanicFactory.getInstance().getMechanic(id)).getCustomVariation();
    }

    public String getDirectionalModel(NoteBlockMechanic mechanic) {
        return mechanic.getSection().getString("model");
    }

    public static enum DirectionalType {
        LOG,
        FURNACE,
        DROPPER;

    }
}

