/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockSoundListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.directional.DirectionalBlock;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock.FarmBlockTask;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.logstrip.LogStripListener;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class NoteBlockMechanicFactory
extends MechanicFactory {
    public static final Map<Integer, NoteBlockMechanic> BLOCK_PER_VARIATION = new HashMap<Integer, NoteBlockMechanic>();
    private static JsonObject variants;
    private static NoteBlockMechanicFactory instance;
    public final List<String> toolTypes;
    private boolean farmBlock;
    private static FarmBlockTask farmBlockTask;
    public final int farmBlockCheckDelay;
    public final boolean customSounds;

    public NoteBlockMechanicFactory(ConfigurationSection section) {
        super(section);
        instance = this;
        variants = new JsonObject();
        variants.add("instrument=harp,powered=false", (JsonElement)NoteBlockMechanicFactory.getModelJson("block/note_block"));
        this.toolTypes = section.getStringList("tool_types");
        this.farmBlockCheckDelay = section.getInt("farmblock_check_delay");
        this.farmBlock = false;
        this.customSounds = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds").getBoolean("noteblock_and_block", true);
        OraxenPlugin.get().getResourcePack().addModifiers(this.getMechanicID(), packFolder -> {
            OraxenPlugin.get().getResourcePack();
            ResourcePack.writeStringToVirtual("assets/minecraft/blockstates", "note_block.json", this.getBlockstateContent());
        });
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new NoteBlockMechanicListener(), new LogStripListener());
        if (this.customSounds) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new NoteBlockSoundListener());
        }
        if (VersionUtil.isPaperServer()) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new NoteBlockMechanicListener.NoteBlockMechanicPaperListener());
            if (!NMSHandlers.isNoteblockUpdatesDisabled()) {
                MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new NoteBlockMechanicListener.NoteBlockMechanicPhysicsListener());
                if (VersionUtil.isSupportedVersionOrNewer("1.20.1")) {
                    Logs.logError("Papers block-updates.disable-noteblock-updates is not enabled.");
                    Logs.logWarning("It is recommended to enable this setting for improved performance and prevent bugs with noteblocks");
                    Logs.logWarning("Otherwise Oraxen needs to listen to very taxing events, which also introduces some bugs");
                    Logs.logWarning("You can enable this setting in ServerFolder/config/paper-global.yml", true);
                }
            }
        }
    }

    public static String getInstrumentName(int id) {
        return switch (id % 400 / 25) {
            case 1 -> "basedrum";
            case 2 -> "snare";
            case 3 -> "hat";
            case 4 -> "bass";
            case 5 -> "flute";
            case 6 -> "bell";
            case 7 -> "guitar";
            case 8 -> "chime";
            case 9 -> "xylophone";
            case 10 -> "iron_xylophone";
            case 11 -> "cow_bell";
            case 12 -> "didgeridoo";
            case 13 -> "bit";
            case 14 -> "banjo";
            case 15 -> "pling";
            default -> "harp";
        };
    }

    public static JsonObject getModelJson(String modelName) {
        JsonObject content = new JsonObject();
        content.addProperty("model", modelName);
        return content;
    }

    public static JsonObject getDirectionalModelJson(String modelName, NoteBlockMechanic mechanic, NoteBlockMechanic parentMechanic) {
        String itemId = mechanic.getItemID();
        JsonObject content = new JsonObject();
        DirectionalBlock parent = parentMechanic.getDirectional();
        String subBlockModel = mechanic.getDirectional().getDirectionalModel(mechanic);
        content.addProperty("model", subBlockModel != null ? subBlockModel : modelName);
        if (subBlockModel != null && !Objects.equals(subBlockModel, modelName)) {
            return content;
        }
        if (Objects.equals(parent.getYBlock(), itemId)) {
            return content;
        }
        if (Objects.equals(parent.getXBlock(), itemId)) {
            content.addProperty("x", (Number)90);
            content.addProperty("z", (Number)90);
        } else if (Objects.equals(parent.getZBlock(), itemId)) {
            content.addProperty("y", (Number)90);
            content.addProperty("x", (Number)90);
        } else {
            if (Objects.equals(parent.getNorthBlock(), itemId)) {
                return content;
            }
            if (Objects.equals(parent.getEastBlock(), itemId)) {
                content.addProperty("y", (Number)90);
            } else if (Objects.equals(parent.getSouthBlock(), itemId)) {
                content.addProperty("y", (Number)180);
            } else if (Objects.equals(parent.getWestBlock(), itemId)) {
                content.addProperty("z", (Number)90);
                content.addProperty("y", (Number)270);
            } else if (Objects.equals(parent.getUpBlock(), itemId)) {
                content.addProperty("y", (Number)270);
            } else if (Objects.equals(parent.getDownBlock(), itemId)) {
                content.addProperty("x", (Number)180);
            }
        }
        return content;
    }

    public static String getBlockstateVariantName(int id) {
        return NoteBlockMechanicFactory.getBlockstateVariantName(NoteBlockMechanicFactory.getInstrumentName(id += 26), id % 25, id >= 400);
    }

    public static String getBlockstateVariantName(String instrument, int note, boolean powered) {
        return "instrument=" + instrument + ",note=" + note + ",powered=" + powered;
    }

    public static NoteBlockMechanic getBlockMechanic(int customVariation) {
        return BLOCK_PER_VARIATION.get(customVariation);
    }

    public static boolean isEnabled() {
        return instance != null;
    }

    public static NoteBlockMechanicFactory getInstance() {
        return instance;
    }

    public static void setBlockModel(Block block, String itemId) {
        MechanicFactory mechanicFactory = MechanicsManager.getMechanicFactory("noteblock");
        NoteBlockMechanic noteBlockMechanic = (NoteBlockMechanic)mechanicFactory.getMechanic(itemId);
        block.setBlockData((BlockData)NoteBlockMechanicFactory.createNoteBlockData(noteBlockMechanic.getCustomVariation()), false);
    }

    private String getBlockstateContent() {
        JsonObject noteblock = new JsonObject();
        noteblock.add("variants", (JsonElement)variants);
        return noteblock.toString();
    }

    @Override
    public Mechanic parse(ConfigurationSection itemMechanicConfiguration) {
        NoteBlockMechanic mechanic = new NoteBlockMechanic(this, itemMechanicConfiguration);
        if (!Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(775)).contains((Object)mechanic.getCustomVariation())) {
            Logs.logError("The custom variation of the block " + mechanic.getItemID() + " is not between 0 and 775!");
            Logs.logWarning("The item has failed to build for now to prevent bugs and issues.");
            return null;
        }
        DirectionalBlock directional = mechanic.getDirectional();
        String modelName = mechanic.getModel(itemMechanicConfiguration.getParent().getParent());
        if (mechanic.isDirectional() && !directional.isParentBlock()) {
            NoteBlockMechanic parentMechanic = directional.getParentMechanic();
            modelName = parentMechanic.getModel(itemMechanicConfiguration.getParent().getParent());
            variants.add(NoteBlockMechanicFactory.getBlockstateVariantName(mechanic.getCustomVariation()), (JsonElement)NoteBlockMechanicFactory.getDirectionalModelJson(modelName, mechanic, parentMechanic));
        } else {
            variants.add(NoteBlockMechanicFactory.getBlockstateVariantName(mechanic.getCustomVariation()), (JsonElement)NoteBlockMechanicFactory.getModelJson(modelName));
        }
        BLOCK_PER_VARIATION.put(mechanic.getCustomVariation(), mechanic);
        this.addToImplemented(mechanic);
        return mechanic;
    }

    public static NoteBlock createNoteBlockData(int id) {
        NoteBlock noteBlock = (NoteBlock)Bukkit.createBlockData((Material)Material.NOTE_BLOCK);
        noteBlock.setInstrument(Instrument.getByType((byte)((byte)((id += 26) % 400 / 25))));
        noteBlock.setNote(new Note(id % 25));
        noteBlock.setPowered(id >= 400);
        return noteBlock;
    }

    public NoteBlock createNoteBlockData(String itemID) {
        return NoteBlockMechanicFactory.createNoteBlockData(((NoteBlockMechanic)NoteBlockMechanicFactory.getInstance().getMechanic(itemID)).getCustomVariation());
    }

    public void registerFarmBlock() {
        if (this.farmBlock) {
            return;
        }
        if (farmBlockTask != null) {
            farmBlockTask.cancel();
        }
        farmBlockTask = new FarmBlockTask(this.farmBlockCheckDelay);
        farmBlockTask.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, this.farmBlockCheckDelay);
        this.farmBlock = true;
    }
}

