/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.block.BlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class LimitedPlacing {
    private final LimitedPlacingType type;
    private final List<Material> blockTypes;
    private final Set<Tag<Material>> blockTags;
    private final List<String> oraxenBlocks;
    private final boolean floor;
    private final boolean roof;
    private final boolean wall;
    private final RadiusLimitation radiusLimitation;

    public LimitedPlacing(ConfigurationSection section) {
        this.floor = section.getBoolean("floor", true);
        this.roof = section.getBoolean("roof", true);
        this.wall = section.getBoolean("wall", true);
        this.type = LimitedPlacingType.valueOf(section.getString("type", "DENY"));
        this.blockTypes = this.getLimitedBlockMaterials(section.getStringList("block_types"));
        this.blockTags = this.getLimitedBlockTags(section.getStringList("block_tags"));
        this.oraxenBlocks = this.getLimitedOraxenBlocks(section.getStringList("oraxen_blocks"));
        ConfigurationSection radiusSection = section.getConfigurationSection("radius_limitation");
        this.radiusLimitation = radiusSection != null ? new RadiusLimitation(radiusSection) : null;
    }

    public boolean isRadiusLimited() {
        return this.radiusLimitation != null && this.radiusLimitation.getRadius() != -1 && this.radiusLimitation.getAmount() != -1;
    }

    public RadiusLimitation getRadiusLimitation() {
        return this.radiusLimitation;
    }

    private List<Material> getLimitedBlockMaterials(List<String> list) {
        return list.stream().map(Material::getMaterial).filter(Objects::nonNull).toList();
    }

    private List<String> getLimitedOraxenBlocks(List<String> list) {
        return list.stream().filter(e -> OraxenBlocks.isOraxenBlock(e) || OraxenFurniture.isFurniture(e)).toList();
    }

    private Set<Tag<Material>> getLimitedBlockTags(List<String> list) {
        HashSet<Tag<Material>> tags = new HashSet<Tag<Material>>();
        for (String string : list) {
            Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)string), Material.class);
            if (tag == null) continue;
            tags.add((Tag<Material>)tag);
        }
        return tags;
    }

    public LimitedPlacingType getType() {
        return this.type;
    }

    public boolean isNotPlacableOn(Block block, BlockFace blockFace) {
        Block placedBlock = block.getRelative(blockFace);
        Block blockBelow = placedBlock.getRelative(BlockFace.DOWN);
        Block blockAbove = placedBlock.getRelative(BlockFace.UP);
        if (this.wall && block.getType().isSolid()) {
            return false;
        }
        if (this.floor && (blockFace == BlockFace.UP || blockBelow.getType().isSolid())) {
            return false;
        }
        if (this.roof && blockFace == BlockFace.DOWN) {
            return false;
        }
        if (this.roof && blockAbove.getType().isSolid()) {
            return false;
        }
        return false;
    }

    public List<Material> getLimitedBlocks() {
        return this.blockTypes;
    }

    public List<String> getLimitedOraxenBlockIds() {
        return this.oraxenBlocks;
    }

    public Set<Tag<Material>> getLimitedTags() {
        return this.blockTags;
    }

    public boolean checkLimitedMechanic(Block block) {
        String oraxenId = this.checkIfOraxenItem(block);
        if (oraxenId == null) {
            if (this.blockTypes.contains(block.getType())) {
                return true;
            }
            for (Tag<Material> tag : this.blockTags) {
                if (!tag.isTagged((Keyed)block.getType())) continue;
                return true;
            }
        }
        return oraxenId != null && !this.oraxenBlocks.isEmpty() && this.oraxenBlocks.contains(oraxenId);
    }

    private String checkIfOraxenItem(Block block) {
        return switch (block.getType()) {
            case Material.NOTE_BLOCK, Material.TRIPWIRE -> {
                Mechanic mechanic = OraxenBlocks.getOraxenBlock(block.getBlockData());
                if (mechanic == null) {
                    yield null;
                }
                yield mechanic.getItemID();
            }
            case Material.BARRIER -> {
                FurnitureMechanic furnitureMechanic = OraxenFurniture.getFurnitureMechanic(block);
                if (furnitureMechanic != null) {
                    yield furnitureMechanic.getItemID();
                }
                yield null;
            }
            case Material.MUSHROOM_STEM -> {
                BlockMechanic blockMechanic = OraxenBlocks.getBlockMechanic(block);
                if (blockMechanic != null) {
                    yield blockMechanic.getItemID();
                }
                yield null;
            }
            default -> null;
        };
    }

    public boolean isFloor() {
        return this.floor;
    }

    public boolean isRoof() {
        return this.roof;
    }

    public boolean isWall() {
        return this.wall;
    }

    public static enum LimitedPlacingType {
        ALLOW,
        DENY;

    }

    public static final class RadiusLimitation {
        private final int radius;
        private final int amount;

        public RadiusLimitation(ConfigurationSection section) {
            this.radius = section.getInt("radius", -1);
            this.amount = section.getInt("amount", -1);
        }

        public int getRadius() {
            return this.radius;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

