/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureBreakEvent;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurniturePlaceEvent;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class FurnitureSoundListener
implements Listener {
    private final Map<Location, BukkitTask> breakerPlaySound = new HashMap<Location, BukkitTask>();

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        for (Map.Entry<Location, BukkitTask> entry : this.breakerPlaySound.entrySet()) {
            if (entry.getKey().isWorldLoaded() || entry.getValue().isCancelled()) continue;
            entry.getValue().cancel();
            this.breakerPlaySound.remove(entry.getKey());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlacingStone(BlockPlaceEvent event) {
        Block block = event.getBlock();
        if (block.getType() == Material.TRIPWIRE) {
            return;
        }
        if (block.getBlockData().getSoundGroup().getPlaceSound() != Sound.BLOCK_STONE_PLACE) {
            return;
        }
        BlockHelpers.playCustomBlockSound(event.getBlock().getLocation(), BlockSounds.VANILLA_STONE_PLACE, BlockSounds.VANILLA_PLACE_VOLUME, BlockSounds.VANILLA_PLACE_PITCH);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBreakingStone(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (block.getType() == Material.TRIPWIRE) {
            return;
        }
        if (block.getBlockData().getSoundGroup().getBreakSound() != Sound.BLOCK_STONE_BREAK) {
            return;
        }
        if (this.breakerPlaySound.containsKey(location)) {
            this.breakerPlaySound.get(location).cancel();
            this.breakerPlaySound.remove(location);
        }
        if (!event.isCancelled() && ProtectionLib.canBreak((Player)event.getPlayer(), (Location)location)) {
            BlockHelpers.playCustomBlockSound(location, BlockSounds.VANILLA_STONE_BREAK, BlockSounds.VANILLA_BREAK_VOLUME, BlockSounds.VANILLA_BREAK_PITCH);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHitStone(BlockDamageEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        SoundGroup soundGroup = block.getBlockData().getSoundGroup();
        if (event.getInstaBreak()) {
            return;
        }
        if (block.getType() == Material.BARRIER || soundGroup.getHitSound() != Sound.BLOCK_STONE_HIT) {
            return;
        }
        if (this.breakerPlaySound.containsKey(location)) {
            return;
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)OraxenPlugin.get(), () -> BlockHelpers.playCustomBlockSound(location, BlockSounds.VANILLA_STONE_HIT, BlockSounds.VANILLA_HIT_VOLUME, BlockSounds.VANILLA_HIT_PITCH), 2L, 4L);
        this.breakerPlaySound.put(location, task);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStopHittingStone(BlockDamageAbortEvent event) {
        Location location = event.getBlock().getLocation();
        if (this.breakerPlaySound.containsKey(location)) {
            this.breakerPlaySound.get(location).cancel();
            this.breakerPlaySound.remove(location);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onStepFall(GenericGameEvent event) {
        float pitch;
        float volume;
        String sound;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!BlockHelpers.isLoaded(entity.getLocation())) {
            return;
        }
        GameEvent gameEvent = event.getEvent();
        Block block = entity.getLocation().getBlock();
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        EntityDamageEvent cause = entity.getLastDamageCause();
        SoundGroup soundGroup = blockBelow.getBlockData().getSoundGroup();
        if (blockBelow.getType() == Material.WATER || blockBelow.getType() == Material.AIR) {
            return;
        }
        if (soundGroup.getStepSound() != Sound.BLOCK_STONE_STEP) {
            return;
        }
        if (gameEvent == GameEvent.HIT_GROUND && cause != null && cause.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!BlockHelpers.isReplaceable(block) || block.getType() == Material.TRIPWIRE) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(blockBelow);
        if (gameEvent == GameEvent.STEP) {
            boolean check = blockBelow.getType() == Material.BARRIER && mechanic != null && mechanic.hasBlockSounds() && mechanic.getBlockSounds().hasStepSound();
            sound = check ? mechanic.getBlockSounds().getStepSound() : BlockSounds.VANILLA_STONE_STEP;
            volume = check ? mechanic.getBlockSounds().getStepVolume() : BlockSounds.VANILLA_STEP_VOLUME;
            pitch = check ? mechanic.getBlockSounds().getStepPitch() : BlockSounds.VANILLA_STEP_PITCH;
        } else if (gameEvent == GameEvent.HIT_GROUND) {
            boolean check = blockBelow.getType() == Material.BARRIER && mechanic != null && mechanic.hasBlockSounds() && mechanic.getBlockSounds().hasFallSound();
            sound = check ? mechanic.getBlockSounds().getFallSound() : BlockSounds.VANILLA_STONE_FALL;
            volume = check ? mechanic.getBlockSounds().getFallVolume() : BlockSounds.VANILLA_FALL_VOLUME;
            pitch = check ? mechanic.getBlockSounds().getFallPitch() : BlockSounds.VANILLA_FALL_PITCH;
        } else {
            return;
        }
        BlockHelpers.playCustomBlockSound(entity.getLocation(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlacingFurniture(OraxenFurniturePlaceEvent event) {
        FurnitureMechanic mechanic = event.getMechanic();
        if (mechanic == null || !mechanic.hasBlockSounds()) {
            return;
        }
        BlockSounds blockSounds = mechanic.getBlockSounds();
        if (blockSounds.hasPlaceSound()) {
            BlockHelpers.playCustomBlockSound(event.getBaseEntity().getLocation(), blockSounds.getPlaceSound(), blockSounds.getPlaceVolume(), blockSounds.getPlacePitch());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreakingFurniture(OraxenFurnitureBreakEvent event) {
        Location loc = event.getBlock() != null ? event.getBlock().getLocation() : event.getBaseEntity().getLocation();
        FurnitureMechanic mechanic = event.getMechanic();
        if (mechanic == null || !mechanic.hasBlockSounds()) {
            return;
        }
        BlockSounds blockSounds = mechanic.getBlockSounds();
        if (blockSounds.hasBreakSound()) {
            BlockHelpers.playCustomBlockSound(loc, blockSounds.getBreakSound(), blockSounds.getBreakVolume(), blockSounds.getBreakPitch());
        }
    }
}

