/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureBreakEvent;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurnitureInteractEvent;
import io.th0rgal.oraxen.api.events.furniture.OraxenFurniturePlaceEvent;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import io.th0rgal.oraxen.utils.breaker.HardnessModifier;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.Objects;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.util.RayTraceResult;

public class FurnitureListener
implements Listener {
    private final MechanicFactory factory;

    public FurnitureListener(MechanicFactory factory) {
        this.factory = factory;
        BreakerSystem.MODIFIERS.add(this.getHardnessModifier());
    }

    private HardnessModifier getHardnessModifier() {
        return new HardnessModifier(){

            @Override
            public boolean isTriggered(Player player, Block block, ItemStack tool) {
                FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
                return mechanic != null && mechanic.hasHardness();
            }

            @Override
            public void breakBlock(Player player, Block block, ItemStack tool) {
                block.setType(Material.AIR);
            }

            @Override
            public long getPeriod(Player player, Block block, ItemStack tool) {
                long period;
                FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
                if (mechanic == null) {
                    return 0L;
                }
                long hardness = mechanic.getHardness();
                double modifier = 1.0;
                if (mechanic.getDrop().canDrop(tool)) {
                    modifier *= 0.4;
                    int diff = mechanic.getDrop().getDiff(tool);
                    if (diff >= 1) {
                        modifier *= Math.pow(0.9, diff);
                    }
                }
                return (period = (long)((double)hardness * modifier)) == 0L && mechanic.hasHardness() ? 1L : period;
            }
        };
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemFrameRotate(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic((Entity)frame);
        if (mechanic == null || mechanic.isRotatable()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onLimitedPlacing(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace blockFace = event.getBlockFace();
        ItemStack item = event.getItem();
        if (item == null || block == null || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(OraxenItems.getIdByItem(item));
        if (mechanic == null || !mechanic.hasLimitedPlacing()) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(block)) {
            return;
        }
        LimitedPlacing limitedPlacing = mechanic.getLimitedPlacing();
        Block belowPlaced = block.getRelative(blockFace).getRelative(BlockFace.DOWN);
        if (limitedPlacing.isNotPlacableOn(block, blockFace)) {
            event.setCancelled(true);
        } else if (limitedPlacing.isRadiusLimited()) {
            LimitedPlacing.RadiusLimitation radiusLimitation = limitedPlacing.getRadiusLimitation();
            int radius = radiusLimitation.getRadius();
            int amount = radiusLimitation.getAmount();
            if (block.getWorld().getNearbyEntities(block.getLocation(), (double)radius, (double)radius, (double)radius).stream().filter(OraxenFurniture::isBaseEntity).filter(e -> OraxenFurniture.getFurnitureMechanic(e).getItemID().equals(mechanic.getItemID())).filter(e -> e.getLocation().distanceSquared(block.getLocation()) <= (double)(radius * radius)).count() >= (long)amount) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.ALLOW) {
            if (!limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.DENY && limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onFurniturePlace(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block placedAgainst = event.getClickedBlock();
        EquipmentSlot hand = event.getHand();
        Block block = this.getTarget(placedAgainst, event.getBlockFace());
        ItemStack item = event.getItem();
        FurnitureMechanic mechanic = this.getMechanic(item, player, block);
        if (mechanic == null || item == null || hand != EquipmentSlot.HAND) {
            return;
        }
        if (block == null || placedAgainst == null || !placedAgainst.canPlace(block.getBlockData())) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!player.isSneaking() && BlockHelpers.isInteractable(placedAgainst)) {
            return;
        }
        BlockData currentBlockData = block.getBlockData();
        Block farm = block.getRelative(BlockFace.DOWN);
        if (mechanic.farmlandRequired && farm.getType() != Material.FARMLAND) {
            return;
        }
        if (mechanic.farmblockRequired) {
            if (farm.getType() != Material.NOTE_BLOCK) {
                return;
            }
            NoteBlockMechanic farmMechanic = OraxenBlocks.getNoteBlockMechanic(farm);
            if (farmMechanic == null || !farmMechanic.hasDryout()) {
                return;
            }
            if (!farmMechanic.getDryout().isFarmBlock()) {
                return;
            }
        }
        BlockPlaceEvent blockPlaceEvent = new BlockPlaceEvent(block, block.getState(), placedAgainst, item, player, true, hand);
        Rotation rotation = this.getRotation(player.getEyeLocation().getYaw(), mechanic.getBarriers().size() > 1);
        float yaw = FurnitureMechanic.rotationToYaw(rotation);
        if (player.getGameMode() == GameMode.ADVENTURE) {
            blockPlaceEvent.setCancelled(true);
        }
        if (mechanic.notEnoughSpace(yaw, block.getLocation())) {
            blockPlaceEvent.setCancelled(true);
            Message.NOT_ENOUGH_SPACE.send((CommandSender)player, new TagResolver[0]);
        }
        if (!blockPlaceEvent.canBuild() || blockPlaceEvent.isCancelled()) {
            block.setBlockData(currentBlockData);
            return;
        }
        Entity baseEntity = mechanic.place(block.getLocation(), item, Float.valueOf(yaw), event.getBlockFace());
        Utils.swingHand(player, event.getHand());
        OraxenFurniturePlaceEvent furniturePlaceEvent = new OraxenFurniturePlaceEvent(mechanic, block, baseEntity, player, item, hand);
        if (!furniturePlaceEvent.callEvent()) {
            OraxenFurniture.remove(baseEntity, null);
            block.setBlockData(currentBlockData);
            return;
        }
        if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            item.setAmount(item.getAmount() - 1);
        }
        event.setUseInteractedBlock(Event.Result.DENY);
    }

    private Block getTarget(Block placedAgainst, BlockFace blockFace) {
        Block target;
        if (BlockHelpers.isReplaceable(placedAgainst)) {
            target = placedAgainst;
        } else {
            target = placedAgainst.getRelative(blockFace);
            if (!(BlockHelpers.isReplaceable(target) || target.getType().isAir() || target.isLiquid() || target.getType() == Material.LIGHT)) {
                return null;
            }
        }
        return target;
    }

    private FurnitureMechanic getMechanic(ItemStack item, Player player, Block placed) {
        String itemID = OraxenItems.getIdByItem(item);
        if (placed == null || itemID == null) {
            return null;
        }
        if (this.factory.isNotImplementedIn(itemID) || BlockHelpers.isStandingInside(player, placed)) {
            return null;
        }
        if (!ProtectionLib.canBuild((Player)player, (Location)placed.getLocation())) {
            return null;
        }
        if (OraxenFurniture.isFurniture(placed)) {
            return null;
        }
        return (FurnitureMechanic)this.factory.getMechanic(itemID);
    }

    private Rotation getRotation(double yaw, boolean restricted) {
        int id = (int)((double)((Location.normalizeYaw((float)((float)yaw)) + 180.0f) * 8.0f / 360.0f) + 0.5) % 8;
        if (restricted && id % 2 != 0) {
            --id;
        }
        return Rotation.values()[id];
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        Hanging entity = event.getEntity();
        if (event.getCause() == HangingBreakEvent.RemoveCause.ENTITY) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic((Entity)entity);
        if (mechanic == null) {
            return;
        }
        if ((entity = mechanic.getBaseEntity((Entity)entity)) == null) {
            return;
        }
        event.setCancelled(true);
        if (mechanic.hasBarriers((Entity)entity) || mechanic.hasHitbox()) {
            return;
        }
        OraxenFurniture.remove((Entity)entity, null);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerBreakHanging(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        if (mechanic == null) {
            return;
        }
        event.setCancelled(true);
        entity = mechanic.getBaseEntity(entity);
        if (entity == null) {
            return;
        }
        if (!ProtectionLib.canBreak((Player)player, (Location)entity.getLocation())) {
            return;
        }
        OraxenFurnitureBreakEvent furnitureBreakEvent = new OraxenFurnitureBreakEvent(mechanic, entity, player, entity.getLocation().getBlock());
        if (!furnitureBreakEvent.callEvent()) {
            return;
        }
        OraxenFurniture.remove(entity, player, furnitureBreakEvent.getDrop());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakingCustomFurniture(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
        if (mechanic == null) {
            return;
        }
        Entity baseEntity = mechanic.getBaseEntity(block);
        if (baseEntity == null) {
            return;
        }
        OraxenFurnitureBreakEvent furnitureBreakEvent = new OraxenFurnitureBreakEvent(mechanic, baseEntity, player, block);
        if (!furnitureBreakEvent.callEvent()) {
            event.setCancelled(true);
            return;
        }
        OraxenFurniture.remove(block.getLocation(), player, furnitureBreakEvent.getDrop());
        event.setDropItems(false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileHitFurniture(ProjectileHitEvent event) {
        boolean isFurniture;
        Location location;
        Player player;
        Block block = event.getHitBlock();
        Entity hitEntity = event.getHitEntity();
        Projectile projectile = event.getEntity();
        Player player2 = player = projectile.getShooter() instanceof Player ? (Player)projectile.getShooter() : null;
        Location location2 = block != null && block.getType() == Material.BARRIER ? block.getLocation() : (location = hitEntity != null ? hitEntity.getLocation() : null);
        boolean bl = block != null ? OraxenFurniture.isFurniture(block) : (isFurniture = hitEntity != null && OraxenFurniture.isFurniture(hitEntity));
        if (location != null && isFurniture) {
            if (player != null && !ProtectionLib.canBreak((Player)player, (Location)location)) {
                event.setCancelled(true);
            } else if (projectile instanceof Explosive) {
                event.setCancelled(true);
                OraxenFurniture.remove(location, player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onProjectileDamageFurniture(EntityDamageByEntityEvent event) {
        Entity entity;
        Entity furniture = event.getEntity();
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(furniture);
        if (mechanic == null || !((entity = event.getDamager()) instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entity;
        Player player = projectile.getShooter() instanceof Player ? (Player)projectile.getShooter() : null;
        event.setCancelled(true);
        if (mechanic.hasBarriers() || !FurnitureListener.isDamagingProjectile(projectile)) {
            return;
        }
        if (player != null && !ProtectionLib.canBreak((Player)player, (Location)furniture.getLocation())) {
            return;
        }
        OraxenFurniture.remove(furniture, player);
    }

    private static boolean isDamagingProjectile(Projectile projectile) {
        return projectile instanceof AbstractArrow || projectile instanceof Fireball;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractFurniture(PlayerInteractEntityEvent event) {
        Entity baseEntity = event.getRightClicked();
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (!ProtectionLib.canInteract((Player)player, (Location)baseEntity.getLocation())) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(baseEntity);
        if (mechanic == null) {
            return;
        }
        Interaction interaction = null;
        if (OraxenPlugin.supportsDisplayEntities && baseEntity instanceof Interaction) {
            Interaction interactionEntity = (Interaction)baseEntity;
            interaction = interactionEntity;
            baseEntity = (baseEntity = mechanic.getBaseEntity((Entity)interaction)) != null ? baseEntity : interaction;
        }
        ItemStack itemInHand = hand == EquipmentSlot.HAND ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        new OraxenFurnitureInteractEvent(mechanic, baseEntity, player, itemInHand, hand).callEvent();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerClickOnFurniture(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || hand != EquipmentSlot.HAND) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (block == null || block.getType() != Material.BARRIER) {
            return;
        }
        if (!ProtectionLib.canInteract((Player)player, (Location)block.getLocation())) {
            return;
        }
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
        if (mechanic == null) {
            return;
        }
        Entity baseEntity = mechanic.getBaseEntity(block);
        if (baseEntity == null) {
            return;
        }
        new OraxenFurnitureInteractEvent(mechanic, baseEntity, player, event.getItem(), hand, block, event.getBlockFace()).callEvent();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFurnitureInteract(OraxenFurnitureInteractEvent event) {
        Player player = event.getPlayer();
        FurnitureMechanic mechanic = event.getMechanic();
        Block block = event.getBlock();
        Entity baseEntity = event.getBaseEntity();
        Entity interactionEntity = event.getInteractionEntity();
        PersistentDataContainer pdc = block != null ? BlockHelpers.getPDC(block) : (interactionEntity != null ? interactionEntity.getPersistentDataContainer() : null);
        mechanic.runClickActions(player);
        if (mechanic.isStorage()) {
            StorageMechanic storage = mechanic.getStorage();
            switch (storage.getStorageType()) {
                case STORAGE: 
                case SHULKER: {
                    storage.openStorage(baseEntity, player);
                    break;
                }
                case PERSONAL: {
                    storage.openPersonalStorage(player, baseEntity.getLocation(), baseEntity);
                    break;
                }
                case DISPOSAL: {
                    storage.openDisposal(player, baseEntity.getLocation(), baseEntity);
                    break;
                }
                case ENDERCHEST: {
                    player.openInventory(player.getEnderChest());
                }
            }
        }
        if (mechanic.hasSeat() && pdc != null && mechanic.isRotatable()) {
            if (!player.isSneaking()) {
                FurnitureMechanic.sitOnSeat(pdc, player);
            } else {
                FurnitureMechanic.rotateFurniture(baseEntity);
            }
        } else if (mechanic.hasSeat() && pdc != null) {
            FurnitureMechanic.sitOnSeat(pdc, player);
        } else if (mechanic.isRotatable()) {
            FurnitureMechanic.rotateFurniture(baseEntity);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMiddleClick(InventoryCreativeEvent event) {
        if (event.getClick() != ClickType.CREATIVE) {
            return;
        }
        Player player = (Player)event.getInventory().getHolder();
        if (player == null) {
            return;
        }
        if (event.getCursor().getType() == Material.BARRIER) {
            RayTraceResult rayTraceResult = player.rayTraceBlocks(6.0);
            if (rayTraceResult == null) {
                return;
            }
            Block block = rayTraceResult.getHitBlock();
            if (block == null) {
                return;
            }
            FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(block);
            if (mechanic == null) {
                return;
            }
            ItemStack item = OraxenItems.getItemById(mechanic.getItemID()).build();
            for (int i = 0; i <= 8; ++i) {
                if (!Objects.equals(OraxenItems.getIdByItem(player.getInventory().getItem(i)), mechanic.getItemID())) continue;
                player.getInventory().setHeldItemSlot(i);
                event.setCancelled(true);
                return;
            }
            event.setCursor(item);
        } else if (OraxenItems.getIdByItem(event.getCursor()) != null) {
            String itemID = OraxenItems.getIdByItem(event.getCursor());
            if (!OraxenFurniture.isFurniture(itemID)) {
                return;
            }
            for (int i = 0; i <= 8; ++i) {
                if (!Objects.equals(OraxenItems.getIdByItem(player.getInventory().getItem(i)), itemID)) continue;
                player.getInventory().setHeldItemSlot(i);
                event.setCancelled(true);
                return;
            }
            event.setCursor(OraxenItems.getItemById(itemID).build());
        }
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (OraxenFurniture.isFurniture(player.getVehicle())) {
            player.leaveVehicle();
        }
    }
}

